/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusterConfigurationValidator;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.DiscoveryType;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.enterprise.configuration.EnterpriseEditionSettings;

@RunWith(value=Parameterized.class)
public class CausalClusterConfigurationValidatorTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Parameterized.Parameter
    public EnterpriseEditionSettings.Mode mode;

    @Parameterized.Parameters(name="{0}")
    public static List<EnterpriseEditionSettings.Mode> recordFormats() {
        return Arrays.asList(EnterpriseEditionSettings.Mode.CORE, EnterpriseEditionSettings.Mode.READ_REPLICA);
    }

    @Test
    public void validateOnlyIfModeIsCoreOrReplica() {
        Config config = Config.builder().withSetting(EnterpriseEditionSettings.mode, EnterpriseEditionSettings.Mode.SINGLE.name()).withSetting(CausalClusteringSettings.initial_discovery_members, "").withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
        Optional value = config.getRaw(CausalClusteringSettings.initial_discovery_members.name());
        Assert.assertTrue((boolean)value.isPresent());
        Assert.assertEquals((Object)"", value.get());
    }

    @Test
    public void validateSuccessList() {
        Config config = Config.builder().withSetting(EnterpriseEditionSettings.mode, EnterpriseEditionSettings.Mode.SINGLE.name()).withSetting(CausalClusteringSettings.initial_discovery_members, "localhost:99,remotehost:2").withSetting(new BoltConnector((String)"bolt").enabled.name(), "true").withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
        Assert.assertEquals(Arrays.asList(new AdvertisedSocketAddress("localhost", 99), new AdvertisedSocketAddress("remotehost", 2)), (Object)config.get(CausalClusteringSettings.initial_discovery_members));
    }

    @Test
    public void validateSuccessKubernetes() {
        Config.builder().withSetting(EnterpriseEditionSettings.mode, EnterpriseEditionSettings.Mode.SINGLE.name()).withSetting(CausalClusteringSettings.discovery_type, DiscoveryType.K8S.name()).withSetting(CausalClusteringSettings.kubernetes_label_selector, "waldo=fred").withSetting(CausalClusteringSettings.kubernetes_service_port_name, "default").withSetting(new BoltConnector((String)"bolt").enabled.name(), "true").withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingBoltConnector() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("A Bolt connector must be configured to run a cluster");
        Config.builder().withSetting(EnterpriseEditionSettings.mode.name(), this.mode.name()).withSetting(CausalClusteringSettings.initial_discovery_members, "").withSetting(CausalClusteringSettings.initial_discovery_members.name(), "localhost:99,remotehost:2").withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingInitialMembersDNS() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing value for 'causal_clustering.initial_discovery_members', which is mandatory with 'causal_clustering.discovery_type=DNS'");
        Config.builder().withSetting(EnterpriseEditionSettings.mode, this.mode.name()).withSetting(CausalClusteringSettings.discovery_type, DiscoveryType.DNS.name()).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingInitialMembersLIST() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing value for 'causal_clustering.initial_discovery_members', which is mandatory with 'causal_clustering.discovery_type=LIST'");
        Config.builder().withSetting(EnterpriseEditionSettings.mode, this.mode.name()).withSetting(CausalClusteringSettings.discovery_type, DiscoveryType.LIST.name()).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingInitialMembersSRV() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing value for 'causal_clustering.initial_discovery_members', which is mandatory with 'causal_clustering.discovery_type=SRV'");
        Config.builder().withSetting(EnterpriseEditionSettings.mode, this.mode.name()).withSetting(CausalClusteringSettings.discovery_type, DiscoveryType.SRV.name()).withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingKubernetesLabelSelector() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing value for 'causal_clustering.kubernetes.label_selector', which is mandatory with 'causal_clustering.discovery_type=K8S'");
        Config.builder().withSetting(EnterpriseEditionSettings.mode, this.mode.name()).withSetting(CausalClusteringSettings.discovery_type, DiscoveryType.K8S.name()).withSetting(CausalClusteringSettings.kubernetes_service_port_name, "default").withSetting(new BoltConnector((String)"bolt").enabled.name(), "true").withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }

    @Test
    public void missingKubernetesPortName() {
        this.expected.expect(InvalidSettingException.class);
        this.expected.expectMessage("Missing value for 'causal_clustering.kubernetes.service_port_name', which is mandatory with 'causal_clustering.discovery_type=K8S'");
        Config.builder().withSetting(EnterpriseEditionSettings.mode, this.mode.name()).withSetting(CausalClusteringSettings.discovery_type, DiscoveryType.K8S.name()).withSetting(CausalClusteringSettings.kubernetes_label_selector, "waldo=fred").withSetting(new BoltConnector((String)"bolt").enabled.name(), "true").withValidator((ConfigurationValidator)new CausalClusterConfigurationValidator()).build();
    }
}

