/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.ChunkedTransactionStream;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.IOCursor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class ChunkedTransactionStreamTest {
    private final StoreId storeId = StoreId.DEFAULT;
    private final ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
    private final CatchupServerProtocol protocol = (CatchupServerProtocol)Mockito.mock(CatchupServerProtocol.class);
    private final IOCursor<CommittedTransactionRepresentation> cursor = (IOCursor)Mockito.mock(IOCursor.class);
    private final int baseTxId = 1;

    @Test
    public void shouldSucceedExactNumberOfTransactions() throws Exception {
        int firstTxId = 1;
        int lastTxId = 10;
        int txIdPromise = 10;
        this.testTransactionStream(firstTxId, lastTxId, txIdPromise, CatchupResult.SUCCESS_END_OF_STREAM);
    }

    @Test
    public void shouldSucceedWithNoTransactions() throws Exception {
        int firstTxId = 1;
        int lastTxId = 1;
        int txIdPromise = 1;
        this.testTransactionStream(firstTxId, lastTxId, txIdPromise, CatchupResult.SUCCESS_END_OF_STREAM);
    }

    @Test
    public void shouldSucceedExcessiveNumberOfTransactions() throws Exception {
        int firstTxId = 1;
        int lastTxId = 10;
        int txIdPromise = 9;
        this.testTransactionStream(firstTxId, lastTxId, txIdPromise, CatchupResult.SUCCESS_END_OF_STREAM);
    }

    @Test
    public void shouldFailIncompleteStreamOfTransactions() throws Exception {
        int firstTxId = 1;
        int lastTxId = 10;
        int txIdPromise = 11;
        this.testTransactionStream(firstTxId, lastTxId, txIdPromise, CatchupResult.E_TRANSACTION_PRUNED);
    }

    @Test
    public void shouldSucceedLargeNumberOfTransactions() throws Exception {
        int firstTxId = 1;
        int lastTxId = 1000;
        int txIdPromise = 900;
        this.testTransactionStream(firstTxId, lastTxId, txIdPromise, CatchupResult.SUCCESS_END_OF_STREAM);
    }

    private void testTransactionStream(int firstTxId, int lastTxId, int txIdPromise, CatchupResult expectedResult) throws Exception {
        int txId;
        ChunkedTransactionStream txStream = new ChunkedTransactionStream((Log)NullLog.getInstance(), this.storeId, (long)firstTxId, (long)txIdPromise, this.cursor, this.protocol);
        ArrayList<Boolean> more = new ArrayList<Boolean>();
        ArrayList<CommittedTransactionRepresentation> txs = new ArrayList<CommittedTransactionRepresentation>();
        for (txId = firstTxId; txId <= lastTxId; ++txId) {
            more.add(true);
            txs.add(this.tx(txId));
        }
        txs.add(null);
        more.add(false);
        Mockito.when((Object)this.cursor.next()).thenAnswer(AdditionalAnswers.returnsElementsOf(more));
        Mockito.when((Object)this.cursor.get()).thenAnswer(AdditionalAnswers.returnsElementsOf(txs));
        Assert.assertFalse((boolean)txStream.isEndOfInput());
        for (txId = firstTxId; txId <= lastTxId; ++txId) {
            Assert.assertEquals((Object)ResponseMessageType.TX, (Object)txStream.readChunk(this.allocator));
            Assert.assertEquals((Object)new TxPullResponse(this.storeId, (CommittedTransactionRepresentation)txs.get(txId - firstTxId)), (Object)txStream.readChunk(this.allocator));
        }
        Assert.assertEquals((Object)ResponseMessageType.TX_STREAM_FINISHED, (Object)txStream.readChunk(this.allocator));
        Assert.assertEquals((Object)new TxStreamFinishedResponse(expectedResult, (long)lastTxId), (Object)txStream.readChunk(this.allocator));
        Assert.assertTrue((boolean)txStream.isEndOfInput());
        txStream.close();
        ((IOCursor)Mockito.verify(this.cursor)).close();
    }

    private CommittedTransactionRepresentation tx(int txId) {
        CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        Mockito.when((Object)tx.getCommitEntry()).thenReturn((Object)new LogEntryCommit((long)txId, 0L));
        return tx;
    }
}

