/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.causalclustering.catchup.CatchupServerHandler;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.storecopy.FakeFile;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.FileSender;
import org.neo4j.causalclustering.catchup.storecopy.GetIndexFilesRequest;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreFileRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyRequest;
import org.neo4j.causalclustering.catchup.storecopy.PrepareStoreCopyResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreamingProtocol;
import org.neo4j.causalclustering.catchup.storecopy.StoreResource;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.TestDirectory;

class TestCatchupServerHandler
implements CatchupServerHandler {
    private final Set<FakeFile> filesystem = new HashSet<FakeFile>();
    private final Set<FakeFile> indexFiles = new HashSet<FakeFile>();
    private final Map<String, Integer> pathToRequestCountMapping = new HashMap<String, Integer>();
    private final Log log;
    private TestDirectory testDirectory;
    private FileSystemAbstraction fileSystemAbstraction;

    TestCatchupServerHandler(LogProvider logProvider, TestDirectory testDirectory, FileSystemAbstraction fileSystemAbstraction) {
        this.log = logProvider.getLog(TestCatchupServerHandler.class);
        this.testDirectory = testDirectory;
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    void addFile(FakeFile fakeFile) {
        this.filesystem.add(fakeFile);
    }

    void addIndexFile(FakeFile fakeFile) {
        this.indexFiles.add(fakeFile);
    }

    public int getRequestCount(String file) {
        return this.pathToRequestCountMapping.getOrDefault(file, 0);
    }

    public ChannelHandler getStoreFileRequestHandler(final CatchupServerProtocol catchupServerProtocol) {
        return new SimpleChannelInboundHandler<GetStoreFileRequest>(){

            protected void channelRead0(ChannelHandlerContext channelHandlerContext, GetStoreFileRequest getStoreFileRequest) {
                TestCatchupServerHandler.this.log.info("Received request for file %s", new Object[]{getStoreFileRequest.file().getName()});
                TestCatchupServerHandler.this.incrementRequestCount(getStoreFileRequest.file());
                try {
                    if (TestCatchupServerHandler.this.handleFileDoesNotExist(channelHandlerContext, getStoreFileRequest)) {
                        catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.MESSAGE_TYPE);
                        return;
                    }
                    TestCatchupServerHandler.this.handleFileExists(channelHandlerContext, getStoreFileRequest.file());
                }
                finally {
                    catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.MESSAGE_TYPE);
                }
            }
        };
    }

    private boolean handleFileDoesNotExist(ChannelHandlerContext channelHandlerContext, GetStoreFileRequest getStoreFileRequest) {
        FakeFile file = this.findFile(this.filesystem, getStoreFileRequest.file().getName());
        if (file.getRemainingFailed() > 0) {
            file.setRemainingFailed(file.getRemainingFailed() - 1);
            this.log.info("FakeServer failing for file %s", new Object[]{getStoreFileRequest.file()});
            this.failed(channelHandlerContext);
            return true;
        }
        return false;
    }

    private void failed(ChannelHandlerContext channelHandlerContext) {
        new StoreFileStreamingProtocol().end(channelHandlerContext, StoreCopyFinishedResponse.Status.E_TOO_FAR_BEHIND);
    }

    private FakeFile findFile(Set<FakeFile> filesystem, String filename) {
        return filesystem.stream().filter(fakeFile -> filename.equals(fakeFile.getFilename())).findFirst().orElseThrow(() -> new RuntimeException("FakeFile should handle all cases with regards to how server should respond"));
    }

    private void handleFileExists(ChannelHandlerContext channelHandlerContext, File file) {
        this.log.info("FakeServer File %s does exist", new Object[]{file});
        channelHandlerContext.writeAndFlush((Object)ResponseMessageType.FILE);
        channelHandlerContext.writeAndFlush((Object)new FileHeader(file.getName()));
        StoreResource storeResource = this.storeResourceFromEntry(file);
        channelHandlerContext.writeAndFlush((Object)new FileSender(storeResource));
        new StoreFileStreamingProtocol().end(channelHandlerContext, StoreCopyFinishedResponse.Status.SUCCESS);
    }

    private void incrementRequestCount(File file) {
        String path = file.getName();
        int count = this.pathToRequestCountMapping.getOrDefault(path, 0);
        this.pathToRequestCountMapping.put(path, count + 1);
    }

    private StoreResource storeResourceFromEntry(File file) {
        file = this.testDirectory.file(file.getName());
        return new StoreResource(file, file.getAbsolutePath(), 16, this.fileSystemAbstraction);
    }

    public ChannelHandler txPullRequestHandler(CatchupServerProtocol catchupServerProtocol) {
        return new ChannelInboundHandlerAdapter();
    }

    public ChannelHandler getStoreIdRequestHandler(CatchupServerProtocol catchupServerProtocol) {
        return new ChannelInboundHandlerAdapter();
    }

    public ChannelHandler storeListingRequestHandler(final CatchupServerProtocol catchupServerProtocol) {
        return new SimpleChannelInboundHandler<PrepareStoreCopyRequest>(){

            protected void channelRead0(ChannelHandlerContext channelHandlerContext, PrepareStoreCopyRequest prepareStoreCopyRequest) {
                channelHandlerContext.writeAndFlush((Object)ResponseMessageType.PREPARE_STORE_COPY_RESPONSE);
                List<File> list = TestCatchupServerHandler.this.filesystem.stream().map(FakeFile::getFile).collect(Collectors.toList());
                File[] files = new File[list.size()];
                files = list.toArray(files);
                long transactionId = 123L;
                ImmutableLongSet indexIds = LongSets.immutable.of(13L);
                channelHandlerContext.writeAndFlush((Object)PrepareStoreCopyResponse.success((File[])files, (LongSet)indexIds, (long)transactionId));
                catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.MESSAGE_TYPE);
            }
        };
    }

    public ChannelHandler getIndexSnapshotRequestHandler(final CatchupServerProtocol catchupServerProtocol) {
        return new SimpleChannelInboundHandler<GetIndexFilesRequest>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void channelRead0(ChannelHandlerContext channelHandlerContext, GetIndexFilesRequest snapshotRequest) {
                TestCatchupServerHandler.this.log.info("Received request for index %s", new Object[]{snapshotRequest.indexId()});
                try {
                    for (FakeFile indexFile : TestCatchupServerHandler.this.indexFiles) {
                        TestCatchupServerHandler.this.log.info("FakeServer File %s does exist", new Object[]{indexFile.getFile()});
                        channelHandlerContext.writeAndFlush((Object)ResponseMessageType.FILE);
                        channelHandlerContext.writeAndFlush((Object)new FileHeader(indexFile.getFile().getName()));
                        StoreResource storeResource = TestCatchupServerHandler.this.storeResourceFromEntry(indexFile.getFile());
                        channelHandlerContext.writeAndFlush((Object)new FileSender(storeResource));
                    }
                    new StoreFileStreamingProtocol().end(channelHandlerContext, StoreCopyFinishedResponse.Status.SUCCESS);
                }
                finally {
                    catchupServerProtocol.expect((Enum)CatchupServerProtocol.State.MESSAGE_TYPE);
                }
            }
        };
    }

    public Optional<ChannelHandler> snapshotHandler(CatchupServerProtocol catchupServerProtocol) {
        return Optional.empty();
    }

    public StoreId getStoreId() {
        return new StoreId(1L, 2L, 3L, 4L);
    }
}

