/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStream;
import org.neo4j.causalclustering.catchup.storecopy.StreamToDiskProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class StreamToDiskTest {
    private static final byte[] DATA = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);

    @Test
    public void shouldLetPageCacheHandleRecordStoresAndNativeLabelScanStoreFiles() throws Exception {
        Monitors monitors = new Monitors();
        StreamToDiskProvider writerProvider = new StreamToDiskProvider(this.directory.databaseDir(), (FileSystemAbstraction)this.fs, monitors);
        for (StoreType type : StoreType.values()) {
            File[] files;
            if (!type.isRecordStore()) continue;
            for (File file : files = (File[])this.directory.databaseLayout().file(type.getDatabaseFile()).toArray(File[]::new)) {
                this.writeAndVerify(writerProvider, file);
            }
        }
        this.writeAndVerify(writerProvider, this.directory.databaseLayout().labelScanStore());
    }

    private void writeAndVerify(StreamToDiskProvider writerProvider, File file) throws Exception {
        try (StoreFileStream acquire = writerProvider.acquire(file.getName(), 16);){
            acquire.write(DATA);
        }
        Assert.assertTrue((String)"Streamed file created.", (boolean)this.fs.fileExists(file));
        Assert.assertEquals((long)DATA.length, (long)this.fs.getFileSize(file));
    }
}

