/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.storecopy.CommitStateHelper;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;

public class CommitStateHelperTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private Config config;
    private CommitStateHelper commitStateHelper;
    private DatabaseLayout databaseLayout;
    private FileSystemAbstraction fsa;

    @Before
    public void setUp() {
        File txLogLocation = new File(this.testDirectory.directory(), "txLogLocation");
        this.config = Config.builder().withSetting(GraphDatabaseSettings.logical_logs_location, txLogLocation.getAbsolutePath()).build();
        File storeDir = this.testDirectory.storeDir();
        this.databaseLayout = DatabaseLayout.of((File)storeDir, (String)((String)this.config.get(GraphDatabaseSettings.active_database)));
        this.fsa = this.testDirectory.getFileSystem();
        this.commitStateHelper = new CommitStateHelper(this.pageCacheRule.getPageCache(this.fsa), this.fsa, this.config);
    }

    @Test
    public void shouldNotHaveTxLogsIfDirectoryDoesNotExist() throws IOException {
        File txDir = (File)this.config.get(GraphDatabaseSettings.logical_logs_location);
        Assert.assertFalse((boolean)txDir.exists());
        Assert.assertFalse((boolean)this.commitStateHelper.hasTxLogs(this.databaseLayout));
    }

    @Test
    public void shouldNotHaveTxLogsIfDirectoryIsEmpty() throws IOException {
        File txDir = (File)this.config.get(GraphDatabaseSettings.logical_logs_location);
        this.fsa.mkdir(txDir);
        Assert.assertFalse((boolean)this.commitStateHelper.hasTxLogs(this.databaseLayout));
    }

    @Test
    public void shouldNotHaveTxLogsIfDirectoryHasFilesWithIncorrectName() throws IOException {
        File txDir = (File)this.config.get(GraphDatabaseSettings.logical_logs_location);
        this.fsa.mkdir(txDir);
        this.fsa.create(new File(txDir, "foo.bar")).close();
        Assert.assertFalse((boolean)this.commitStateHelper.hasTxLogs(this.databaseLayout));
    }

    @Test
    public void shouldHaveTxLogsIfDirectoryHasTxFile() throws IOException {
        File txDir = (File)this.config.get(GraphDatabaseSettings.logical_logs_location);
        this.fsa.mkdir(txDir);
        this.fsa.create(new File(txDir, "neostore.transaction.db.0")).close();
        Assert.assertTrue((boolean)this.commitStateHelper.hasTxLogs(this.databaseLayout));
    }
}

