/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;

public class TestStoreId {
    private TestStoreId() {
    }

    public static void assertAllStoresHaveTheSameStoreId(List<File> coreStoreDirs, FileSystemAbstraction fs) throws Exception {
        Set<StoreId> storeIds = TestStoreId.getStoreIds(coreStoreDirs, fs);
        Assert.assertEquals((String)("Store Ids " + storeIds), (long)1L, (long)storeIds.size());
    }

    public static Set<StoreId> getStoreIds(List<File> coreStoreDirs, FileSystemAbstraction fs) throws Exception {
        HashSet<StoreId> storeIds = new HashSet<StoreId>();
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler);){
            for (File coreStoreDir : coreStoreDirs) {
                storeIds.add(TestStoreId.doReadStoreId(coreStoreDir, pageCache));
            }
        }
        return storeIds;
    }

    private static StoreId doReadStoreId(File databaseDirectory, PageCache pageCache) throws IOException {
        File metadataStore = DatabaseLayout.of((File)databaseDirectory).metadataStore();
        long creationTime = MetaDataStore.getRecord((PageCache)pageCache, (File)metadataStore, (MetaDataStore.Position)MetaDataStore.Position.TIME);
        long randomNumber = MetaDataStore.getRecord((PageCache)pageCache, (File)metadataStore, (MetaDataStore.Position)MetaDataStore.Position.RANDOM_NUMBER);
        long upgradeTime = MetaDataStore.getRecord((PageCache)pageCache, (File)metadataStore, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TIME);
        long upgradeId = MetaDataStore.getRecord((PageCache)pageCache, (File)metadataStore, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID);
        return new StoreId(creationTime, randomNumber, upgradeTime, upgradeId);
    }
}

