/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.causalclustering;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.EnterpriseCluster;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.helpers.CausalClusteringTestHelpers;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.causalclustering.scenarios.EnterpriseDiscoveryServiceType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.VerboseTimeout;

public class ClusterRule
extends ExternalResource {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private File clusterDirectory;
    private Cluster<?> cluster;
    private int noCoreMembers = 3;
    private int noReadReplicas = 3;
    private DiscoveryServiceType discoveryServiceType = EnterpriseDiscoveryServiceType.SHARED;
    private Map<String, String> coreParams = MapUtil.stringMap((String[])new String[0]);
    private Map<String, IntFunction<String>> instanceCoreParams = new HashMap<String, IntFunction<String>>();
    private Map<String, String> readReplicaParams = MapUtil.stringMap((String[])new String[0]);
    private Map<String, IntFunction<String>> instanceReadReplicaParams = new HashMap<String, IntFunction<String>>();
    private String recordFormat = "standard";
    private IpFamily ipFamily = IpFamily.IPV4;
    private boolean useWildcard;
    private VerboseTimeout.VerboseTimeoutBuilder timeoutBuilder = new VerboseTimeout.VerboseTimeoutBuilder().withTimeout(15L, TimeUnit.MINUTES);
    private Set<String> dbNames = Collections.singleton(CausalClusteringSettings.database.getDefaultValue());

    public Statement apply(Statement base, final Description description) {
        final Statement timeoutStatement = this.timeoutBuilder != null ? this.timeoutBuilder.build().apply(base, description) : base;
        Statement testMethod = new Statement(){

            public void evaluate() throws Throwable {
                String name = description.getMethodName() != null ? description.getMethodName() : description.getClassName();
                ClusterRule.this.clusterDirectory = ClusterRule.this.testDirectory.directory(name);
                timeoutStatement.evaluate();
            }
        };
        Statement testMethodWithBeforeAndAfter = super.apply(testMethod, description);
        return this.testDirectory.apply(testMethodWithBeforeAndAfter, description);
    }

    protected void after() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public Cluster<?> startCluster() throws Exception {
        this.createCluster();
        this.cluster.start();
        for (String dbName : this.dbNames) {
            this.cluster.awaitLeader(dbName);
        }
        return this.cluster;
    }

    public Cluster<?> createCluster() {
        if (this.cluster == null) {
            this.cluster = new EnterpriseCluster(this.clusterDirectory, this.noCoreMembers, this.noReadReplicas, this.discoveryServiceType.createFactory(), this.coreParams, this.instanceCoreParams, this.readReplicaParams, this.instanceReadReplicaParams, this.recordFormat, this.ipFamily, this.useWildcard, this.dbNames);
        }
        return this.cluster;
    }

    public TestDirectory testDirectory() {
        return this.testDirectory;
    }

    public File clusterDirectory() {
        return this.clusterDirectory;
    }

    public ClusterRule withDatabaseNames(Set<String> dbNames) {
        this.dbNames = dbNames;
        Map<Integer, String> coreDBMap = CausalClusteringTestHelpers.distributeDatabaseNamesToHostNums(this.noCoreMembers, dbNames);
        Map<Integer, String> rrDBMap = CausalClusteringTestHelpers.distributeDatabaseNamesToHostNums(this.noReadReplicas, dbNames);
        Map<String, Long> minCoresPerDb = coreDBMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.counting()));
        HashMap minCoresSettingsMap = new HashMap();
        for (Map.Entry<Integer, String> entry : coreDBMap.entrySet()) {
            Optional<Long> minNumCores = Optional.ofNullable(minCoresPerDb.get(entry.getValue()));
            minNumCores.ifPresent(n -> minCoresSettingsMap.put(entry.getKey(), n.toString()));
        }
        this.withInstanceCoreParam(CausalClusteringSettings.database, coreDBMap::get);
        this.withInstanceCoreParam(CausalClusteringSettings.minimum_core_cluster_size_at_formation, minCoresSettingsMap::get);
        this.withInstanceReadReplicaParam(CausalClusteringSettings.database, rrDBMap::get);
        return this;
    }

    public ClusterRule withNumberOfCoreMembers(int noCoreMembers) {
        this.noCoreMembers = noCoreMembers;
        return this;
    }

    public ClusterRule withNumberOfReadReplicas(int noReadReplicas) {
        this.noReadReplicas = noReadReplicas;
        return this;
    }

    public ClusterRule withDiscoveryServiceType(DiscoveryServiceType discoveryServiceType) {
        this.discoveryServiceType = discoveryServiceType;
        return this;
    }

    public ClusterRule withSharedCoreParams(Map<String, String> params) {
        this.coreParams.putAll(params);
        return this;
    }

    public ClusterRule withSharedCoreParam(Setting<?> key, String value) {
        this.coreParams.put(key.name(), value);
        return this;
    }

    public ClusterRule withInstanceCoreParams(Map<String, IntFunction<String>> params) {
        this.instanceCoreParams.putAll(params);
        return this;
    }

    public ClusterRule withInstanceCoreParam(Setting<?> key, IntFunction<String> valueFunction) {
        this.instanceCoreParams.put(key.name(), valueFunction);
        return this;
    }

    public ClusterRule withSharedReadReplicaParams(Map<String, String> params) {
        this.readReplicaParams.putAll(params);
        return this;
    }

    public ClusterRule withSharedReadReplicaParam(Setting<?> key, String value) {
        this.readReplicaParams.put(key.name(), value);
        return this;
    }

    public ClusterRule withInstanceReadReplicaParams(Map<String, IntFunction<String>> params) {
        this.instanceReadReplicaParams.putAll(params);
        return this;
    }

    public ClusterRule withInstanceReadReplicaParam(Setting<?> key, IntFunction<String> valueFunction) {
        this.instanceReadReplicaParams.put(key.name(), valueFunction);
        return this;
    }

    public ClusterRule withRecordFormat(String recordFormat) {
        this.recordFormat = recordFormat;
        return this;
    }

    public ClusterRule withClusterDirectory(File clusterDirectory) {
        this.clusterDirectory = clusterDirectory;
        return this;
    }

    public ClusterRule withIpFamily(IpFamily ipFamily) {
        this.ipFamily = ipFamily;
        return this;
    }

    public ClusterRule useWildcard(boolean useWildcard) {
        this.useWildcard = useWildcard;
        return this;
    }

    public ClusterRule withTimeout(long timeout, TimeUnit unit) {
        this.timeoutBuilder = new VerboseTimeout.VerboseTimeoutBuilder().withTimeout(timeout, unit);
        return this;
    }

    public ClusterRule withNoTimeout() {
        this.timeoutBuilder = null;
        return this;
    }
}

