/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.strategies.LeaderOnlyStrategy;
import org.neo4j.causalclustering.upstream.strategies.TopologyServiceThatPrioritisesItself;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class LeaderOnlyStrategyTest {
    @Test
    public void ignoresSelf() throws UpstreamDatabaseSelectionException {
        final MemberId myself = new MemberId(new UUID(1234L, 5678L));
        String groupName = "groupName";
        LeaderOnlyStrategy leaderOnlyStrategy = new LeaderOnlyStrategy();
        TopologyServiceThatPrioritisesItself topologyServiceNoRetriesStrategy = new TopologyServiceThatPrioritisesItself(myself, groupName){

            @Override
            public Map<MemberId, RoleInfo> allCoreRoles() {
                HashMap<MemberId, RoleInfo> roles = new HashMap<MemberId, RoleInfo>();
                roles.put(myself, RoleInfo.LEADER);
                roles.put(this.coreNotSelf, RoleInfo.LEADER);
                return roles;
            }
        };
        leaderOnlyStrategy.inject((TopologyService)topologyServiceNoRetriesStrategy, Config.defaults(), (LogProvider)NullLogProvider.getInstance(), myself);
        Optional resolved = leaderOnlyStrategy.upstreamDatabase();
        Assert.assertTrue((boolean)resolved.isPresent());
        Assert.assertNotEquals((Object)myself, resolved.get());
    }
}

