/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.causalclustering.scenarios.EnterpriseDiscoveryServiceType;
import org.neo4j.causalclustering.scenarios.SampleData;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.txtracking.TransactionIdTracker;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.util.UnsatisfiedDependencyException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;

public class ReadReplicaReplicationIT {
    private static final int NR_CORE_MEMBERS = 3;
    private static final int NR_READ_REPLICAS = 1;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(1).withSharedCoreParam(CausalClusteringSettings.cluster_topology_refresh, "5s").withDiscoveryServiceType(EnterpriseDiscoveryServiceType.HAZELCAST);
    private final BiConsumer<CoreGraphDatabase, Transaction> createSomeData = (db, tx) -> {
        SampleData.createData((GraphDatabaseService)db, 10);
        tx.success();
    };

    @Test
    public void shouldNotBeAbleToWriteToReadReplica() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        ReadReplicaGraphDatabase readReplica = cluster.findAnyReadReplica().database();
        try (Transaction tx = readReplica.beginTx();){
            Node node = readReplica.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            node.addLabel(Label.label((String)"Foo"));
            tx.success();
            Assert.fail((String)"should have thrown");
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }

    @Test
    public void allServersBecomeAvailable() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        for (ReadReplica readReplica : cluster.readReplicas()) {
            ThrowingSupplier availability = () -> readReplica.database().isAvailable(0L);
            org.neo4j.test.assertion.Assert.assertEventually((String)"read replica becomes available", (ThrowingSupplier)availability, (Matcher)Is.is((Object)true), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @Test
    public void shouldEventuallyPullTransactionDownToAllReadReplicas() throws Exception {
        Cluster<?> cluster = this.clusterRule.withNumberOfReadReplicas(0).startCluster();
        int nodesBeforeReadReplicaStarts = 1;
        cluster.coreTx((db, tx) -> {
            db.schema().constraintFor(Label.label((String)"Foo")).assertPropertyIsUnique("foobar").create();
            tx.success();
        });
        for (int i = 0; i < 100; ++i) {
            cluster.coreTx((db, tx) -> {
                SampleData.createData((GraphDatabaseService)db, nodesBeforeReadReplicaStarts);
                tx.success();
            });
        }
        HashSet labelScanStoreFiles = new HashSet();
        cluster.coreTx((db, tx) -> ReadReplicaReplicationIT.gatherLabelScanStoreFiles((GraphDatabaseAPI)db, labelScanStoreFiles));
        AtomicBoolean labelScanStoreCorrectlyPlaced = new AtomicBoolean(false);
        Monitors monitors = new Monitors();
        ReadReplica rr = cluster.addReadReplicaWithIdAndMonitors(0, monitors);
        monitors.addMonitorListener(file -> {
            if (labelScanStoreFiles.contains(file.toPath().getFileName())) {
                labelScanStoreCorrectlyPlaced.set(true);
            }
        }, new String[0]);
        rr.start();
        for (int i = 0; i < 100; ++i) {
            cluster.coreTx((db, tx) -> {
                SampleData.createData((GraphDatabaseService)db, nodesBeforeReadReplicaStarts);
                tx.success();
            });
        }
        for (ReadReplica server : cluster.readReplicas()) {
            ReadReplicaGraphDatabase readReplica = server.database();
            Transaction tx2 = readReplica.beginTx();
            Throwable throwable = null;
            try {
                ThrowingSupplier nodeCount = () -> ReadReplicaReplicationIT.lambda$shouldEventuallyPullTransactionDownToAllReadReplicas$6((GraphDatabaseService)readReplica);
                org.neo4j.test.assertion.Assert.assertEventually((String)"node to appear on read replica", (ThrowingSupplier)nodeCount, (Matcher)Is.is((Object)400L), (long)1L, (TimeUnit)TimeUnit.MINUTES);
                for (Node node : readReplica.getAllNodes()) {
                    MatcherAssert.assertThat((Object)node.getProperty("foobar").toString(), (Matcher)CoreMatchers.startsWith((String)"baz_bat"));
                }
                tx2.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx2 == null) continue;
                if (throwable != null) {
                    try {
                        tx2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx2.close();
            }
        }
        Assert.assertTrue((boolean)labelScanStoreCorrectlyPlaced.get());
    }

    private static void gatherLabelScanStoreFiles(GraphDatabaseAPI db, Set<Path> labelScanStoreFiles) {
        Path databaseDirectory = db.databaseLayout().databaseDirectory().toPath();
        LabelScanStore labelScanStore = (LabelScanStore)db.getDependencyResolver().resolveDependency(LabelScanStore.class);
        try (ResourceIterator files = labelScanStore.snapshotStoreFiles();){
            Path relativePath = databaseDirectory.relativize(((File)files.next()).toPath().toAbsolutePath());
            labelScanStoreFiles.add(relativePath);
        }
    }

    @Test
    public void shouldShutdownRatherThanPullUpdatesFromCoreMemberWithDifferentStoreIdIfLocalStoreIsNonEmpty() throws Exception {
        Cluster<?> cluster = this.clusterRule.withNumberOfReadReplicas(0).startCluster();
        cluster.coreTx(this.createSomeData);
        cluster.awaitCoreMemberWithRole(Role.FOLLOWER, 2L, TimeUnit.SECONDS);
        ReadReplica readReplica = cluster.addReadReplicaWithId(4);
        readReplica.start();
        readReplica.database().beginTx().close();
        ReadReplicaReplicationIT.changeStoreId(readReplica);
        readReplica.shutdown();
        try {
            readReplica.start();
            Assert.fail((String)"Should have failed to start");
        }
        catch (RuntimeException required) {
            MatcherAssert.assertThat((Object)required.getCause(), (Matcher)Matchers.instanceOf(LifecycleException.class));
            MatcherAssert.assertThat((Object)required.getCause().getCause(), (Matcher)Matchers.instanceOf(Exception.class));
            MatcherAssert.assertThat((Object)required.getCause().getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"This read replica cannot join the cluster. The local database is not empty and has a mismatching storeId:"));
        }
    }

    @Test
    public void aReadReplicShouldBeAbleToRejoinTheCluster() throws Exception {
        int readReplicaId = 4;
        Cluster<?> cluster = this.clusterRule.withNumberOfReadReplicas(0).startCluster();
        cluster.coreTx(this.createSomeData);
        cluster.addReadReplicaWithId(readReplicaId).start();
        cluster.coreTx(this.createSomeData);
        Predicates.awaitEx(() -> ReadReplicaReplicationIT.readReplicasUpToDateAsTheLeader(cluster.awaitLeader(), cluster.readReplicas()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        cluster.removeReadReplicaWithMemberId(readReplicaId);
        cluster.coreTx(this.createSomeData);
        cluster.addReadReplicaWithId(readReplicaId).start();
        Predicates.awaitEx(() -> ReadReplicaReplicationIT.readReplicasUpToDateAsTheLeader(cluster.awaitLeader(), cluster.readReplicas()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Function<ClusterMember, DbRepresentation> toRep = db -> DbRepresentation.of(db.database());
        Set dbs = cluster.coreMembers().stream().map(toRep).collect(Collectors.toSet());
        dbs.addAll(cluster.readReplicas().stream().map(toRep).collect(Collectors.toSet()));
        cluster.shutdown();
        Assert.assertEquals((long)1L, (long)dbs.size());
    }

    @Test
    public void readReplicasShouldRestartIfTheWholeClusterIsRestarted() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        cluster.shutdown();
        cluster.start();
        for (ReadReplica readReplica : cluster.readReplicas()) {
            ThrowingSupplier availability = () -> readReplica.database().isAvailable(0L);
            org.neo4j.test.assertion.Assert.assertEventually((String)"read replica becomes available", (ThrowingSupplier)availability, (Matcher)Is.is((Object)true), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @Test
    public void shouldBeAbleToDownloadANewStoreAfterPruning() throws Exception {
        CoreClusterMember core;
        Map params = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "keep_none", GraphDatabaseSettings.logical_log_rotation_threshold.name(), "1M", GraphDatabaseSettings.check_point_interval_time.name(), "100ms"});
        Cluster<?> cluster = this.clusterRule.withSharedCoreParams(params).startCluster();
        cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 10);
            tx.success();
        });
        Predicates.awaitEx(() -> ReadReplicaReplicationIT.readReplicasUpToDateAsTheLeader(cluster.awaitLeader(), cluster.readReplicas()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        ReadReplica readReplica = cluster.getReadReplicaById(0);
        long highestReadReplicaLogVersion = ReadReplicaReplicationIT.physicalLogFiles(readReplica).getHighestLogVersion();
        readReplica.shutdown();
        while (ReadReplicaReplicationIT.physicalLogFiles(core = cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 1000);
            tx.success();
        })).getLowestLogVersion() <= highestReadReplicaLogVersion) {
        }
        readReplica.start();
        Predicates.awaitEx(() -> ReadReplicaReplicationIT.readReplicasUpToDateAsTheLeader(cluster.awaitLeader(), cluster.readReplicas()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        org.neo4j.test.assertion.Assert.assertEventually((String)"The read replica has the same data as the core members", () -> DbRepresentation.of((GraphDatabaseService)readReplica.database()), (Matcher)Matchers.equalTo((Object)DbRepresentation.of((GraphDatabaseService)cluster.awaitLeader().database())), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldBeAbleToPullTxAfterHavingDownloadedANewStoreAfterPruning() throws Exception {
        CoreClusterMember core;
        Map params = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), "keep_none", GraphDatabaseSettings.logical_log_rotation_threshold.name(), "1M", GraphDatabaseSettings.check_point_interval_time.name(), "100ms"});
        Cluster<?> cluster = this.clusterRule.withSharedCoreParams(params).startCluster();
        cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 10);
            tx.success();
        });
        Predicates.awaitEx(() -> ReadReplicaReplicationIT.readReplicasUpToDateAsTheLeader(cluster.awaitLeader(), cluster.readReplicas()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        ReadReplica readReplica = cluster.getReadReplicaById(0);
        long highestReadReplicaLogVersion = ReadReplicaReplicationIT.physicalLogFiles(readReplica).getHighestLogVersion();
        readReplica.shutdown();
        while (ReadReplicaReplicationIT.physicalLogFiles(core = cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 1000);
            tx.success();
        })).getLowestLogVersion() <= highestReadReplicaLogVersion) {
        }
        readReplica.start();
        Predicates.awaitEx(() -> ReadReplicaReplicationIT.readReplicasUpToDateAsTheLeader(cluster.awaitLeader(), cluster.readReplicas()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        cluster.coreTx((db, tx) -> {
            SampleData.createData((GraphDatabaseService)db, 10);
            tx.success();
        });
        org.neo4j.test.assertion.Assert.assertEventually((String)"The read replica has the same data as the core members", () -> DbRepresentation.of((GraphDatabaseService)readReplica.database()), (Matcher)Matchers.equalTo((Object)DbRepresentation.of((GraphDatabaseService)cluster.awaitLeader().database())), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void transactionsShouldNotAppearOnTheReadReplicaWhilePollingIsPaused() throws Throwable {
        Cluster<?> cluster = this.clusterRule.startCluster();
        ReadReplicaGraphDatabase readReplicaGraphDatabase = cluster.findAnyReadReplica().database();
        CatchupPollingProcess pollingClient = (CatchupPollingProcess)readReplicaGraphDatabase.getDependencyResolver().resolveDependency(CatchupPollingProcess.class);
        pollingClient.stop();
        cluster.coreTx((coreGraphDatabase, transaction) -> {
            coreGraphDatabase.createNode();
            transaction.success();
        });
        CoreGraphDatabase leaderDatabase = cluster.awaitLeader().database();
        long transactionVisibleOnLeader = ReadReplicaReplicationIT.transactionIdTracker((GraphDatabaseAPI)leaderDatabase).newestEncounteredTxId();
        try {
            ReadReplicaReplicationIT.transactionIdTracker((GraphDatabaseAPI)readReplicaGraphDatabase).awaitUpToDate(transactionVisibleOnLeader, Duration.ofSeconds(15L));
            Assert.fail((String)"should have thrown exception");
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        pollingClient.start();
        ReadReplicaReplicationIT.transactionIdTracker((GraphDatabaseAPI)readReplicaGraphDatabase).awaitUpToDate(transactionVisibleOnLeader, Duration.ofSeconds(15L));
    }

    private static TransactionIdTracker transactionIdTracker(GraphDatabaseAPI database) {
        Supplier transactionIdStore = database.getDependencyResolver().provideDependency(TransactionIdStore.class);
        AvailabilityGuard databaseAvailabilityGuard = (AvailabilityGuard)database.getDependencyResolver().resolveDependency(DatabaseAvailabilityGuard.class);
        return new TransactionIdTracker(transactionIdStore, databaseAvailabilityGuard);
    }

    private static LogFiles physicalLogFiles(ClusterMember clusterMember) {
        return (LogFiles)clusterMember.database().getDependencyResolver().resolveDependency(LogFiles.class);
    }

    private static boolean readReplicasUpToDateAsTheLeader(CoreClusterMember leader, Collection<ReadReplica> readReplicas) {
        long leaderTxId = ReadReplicaReplicationIT.lastClosedTransactionId(true, (GraphDatabaseFacade)leader.database());
        return readReplicas.stream().map(ReadReplica::database).map(db -> ReadReplicaReplicationIT.lastClosedTransactionId(false, (GraphDatabaseFacade)db)).reduce(true, (acc, txId) -> acc != false && txId == leaderTxId, Boolean::logicalAnd);
    }

    private static void changeStoreId(ReadReplica replica) throws IOException {
        File neoStoreFile = DatabaseLayout.of((File)replica.databaseDirectory()).metadataStore();
        PageCache pageCache = (PageCache)replica.database().getDependencyResolver().resolveDependency(PageCache.class);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.TIME, (long)System.currentTimeMillis());
    }

    private static long lastClosedTransactionId(boolean fail, GraphDatabaseFacade db) {
        try {
            return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        }
        catch (IllegalStateException | UnsatisfiedDependencyException ex) {
            if (!fail) {
                return -1L;
            }
            throw ex;
        }
    }

    @Test
    public void shouldThrowExceptionIfReadReplicaRecordFormatDiffersToCoreRecordFormat() throws Exception {
        Cluster<?> cluster = this.clusterRule.withNumberOfReadReplicas(0).withRecordFormat("high_limit").startCluster();
        cluster.coreTx(this.createSomeData);
        try {
            String format = "standard";
            cluster.addReadReplicaWithIdAndRecordFormat(0, format).start();
            Assert.fail((String)("starting read replica with '" + format + "' format should have failed"));
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to start database with copied store"));
        }
    }

    @Test
    public void shouldBeAbleToCopyStoresFromCoreToReadReplica() throws Exception {
        Map params = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.raft_log_rotation_size.name(), "1k", CausalClusteringSettings.raft_log_pruning_frequency.name(), "500ms", CausalClusteringSettings.state_machine_flush_window_size.name(), "1", CausalClusteringSettings.raft_log_pruning_strategy.name(), "1 entries"});
        Cluster<?> cluster = this.clusterRule.withNumberOfReadReplicas(0).withSharedCoreParams(params).withRecordFormat("high_limit").startCluster();
        cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"L")});
            for (int i = 0; i < 10; ++i) {
                node.setProperty("prop-" + i, (Object)"this is a quite long string to get to the log limit soonish");
            }
            tx.success();
        });
        long baseVersion = ReadReplicaReplicationIT.versionBy(cluster.awaitLeader().raftLogDirectory(), Math::max);
        CoreClusterMember coreGraphDatabase = null;
        for (int j = 0; j < 2; ++j) {
            coreGraphDatabase = cluster.coreTx((db, tx) -> {
                Node node = db.createNode(new Label[]{Label.label((String)"L")});
                for (int i = 0; i < 10; ++i) {
                    node.setProperty("prop-" + i, (Object)"this is a quite long string to get to the log limit soonish");
                }
                tx.success();
            });
        }
        File raftLogDir = coreGraphDatabase.raftLogDirectory();
        org.neo4j.test.assertion.Assert.assertEventually((String)"pruning happened", () -> ReadReplicaReplicationIT.versionBy(raftLogDir, Math::min), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(baseVersion)), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        cluster.addReadReplicaWithIdAndRecordFormat(4, "high_limit").start();
        for (ReadReplica readReplica : cluster.readReplicas()) {
            org.neo4j.test.assertion.Assert.assertEventually((String)"read replica available", () -> readReplica.database().isAvailable(0L), (Matcher)Is.is((Object)true), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private static long versionBy(File raftLogDir, BinaryOperator<Long> operator) throws IOException {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            SortedMap logs = new FileNames(raftLogDir).getAllFiles((FileSystemAbstraction)fileSystem, (Log)Mockito.mock(Log.class));
            long l = logs.keySet().stream().reduce(operator).orElseThrow(IllegalStateException::new);
            return l;
        }
    }

    @Test
    public void pageFaultsFromReplicationMustCountInMetrics() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        Function<ReadReplica, PageCacheCounters> getPageCacheCounters = ccm -> (PageCacheCounters)ccm.database().getDependencyResolver().resolveDependency(PageCacheCounters.class);
        List countersList = cluster.readReplicas().stream().map(getPageCacheCounters).collect(Collectors.toList());
        long[] initialPins = countersList.stream().mapToLong(PageCacheCounters::pins).toArray();
        cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        int minimumUpdatedMembersCount = countersList.size() / 2 + 1;
        org.neo4j.test.assertion.Assert.assertEventually((String)"Expected followers to eventually increase pin counts", () -> {
            long[] pinsAfterCommit = countersList.stream().mapToLong(PageCacheCounters::pins).toArray();
            int membersWithIncreasedPinCount = 0;
            for (int i = 0; i < initialPins.length; ++i) {
                long before = initialPins[i];
                long after = pinsAfterCommit[i];
                if (before >= after) continue;
                ++membersWithIncreasedPinCount;
            }
            return membersWithIncreasedPinCount;
        }, (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(minimumUpdatedMembersCount))), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static /* synthetic */ Long lambda$shouldEventuallyPullTransactionDownToAllReadReplicas$6(GraphDatabaseService readReplica) throws Exception {
        return Iterables.count((Iterable)readReplica.getAllNodes());
    }
}

