/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.test.causalclustering.ClusterRule;

public class PreElectionIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withSharedCoreParam(CausalClusteringSettings.leader_election_timeout, "2s").withSharedCoreParam(CausalClusteringSettings.enable_pre_voting, "true");

    @Test
    public void shouldActuallyStartAClusterWithPreVoting() throws Exception {
        this.clusterRule.startCluster();
    }

    @Test
    public void shouldActuallyStartAClusterWithPreVotingAndARefuseToBeLeader() throws Throwable {
        this.clusterRule.withInstanceCoreParam(CausalClusteringSettings.refuse_to_be_leader, this::firstServerRefusesToBeLeader).withSharedCoreParam(CausalClusteringSettings.multi_dc_license, "true");
        this.clusterRule.startCluster();
    }

    @Test
    public void shouldNotStartAnElectionIfAMinorityOfServersHaveTimedOutOnHeartbeats() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        CoreClusterMember follower = cluster.awaitCoreMemberWithRole(Role.FOLLOWER, 1L, TimeUnit.MINUTES);
        follower.raft().triggerElection(Clock.systemUTC());
        try {
            cluster.awaitCoreMemberWithRole(Role.CANDIDATE, 1L, TimeUnit.MINUTES);
            Assert.fail((String)"Should not have started an election if less than a quorum have timed out");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void shouldStartElectionIfLeaderRemoved() throws Exception {
        Cluster<?> cluster = this.clusterRule.startCluster();
        CoreClusterMember oldLeader = cluster.awaitLeader();
        cluster.removeCoreMember(oldLeader);
        CoreClusterMember newLeader = cluster.awaitLeader();
        Assert.assertThat((Object)newLeader.serverId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)oldLeader.serverId())));
    }

    @Test
    public void shouldElectANewLeaderIfAServerRefusesToBeLeader() throws Exception {
        this.clusterRule.withInstanceCoreParam(CausalClusteringSettings.refuse_to_be_leader, this::firstServerRefusesToBeLeader).withSharedCoreParam(CausalClusteringSettings.multi_dc_license, "true");
        Cluster<?> cluster = this.clusterRule.startCluster();
        CoreClusterMember oldLeader = cluster.awaitLeader();
        cluster.removeCoreMember(oldLeader);
        CoreClusterMember newLeader = cluster.awaitLeader();
        Assert.assertThat((Object)newLeader.serverId(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)oldLeader.serverId())));
    }

    private String firstServerRefusesToBeLeader(int id) {
        return id == 0 ? "true" : "false";
    }
}

