/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.test.causalclustering.ClusterRule;

public class CoreReplicationIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withTimeout(1000L, TimeUnit.SECONDS);
    private Cluster<?> cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldReplicateTransactionsToCoreMembers() throws Exception {
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Assert.assertEquals((long)1L, (long)DataCreator.countNodes(leader));
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
    }

    @Test
    public void shouldNotAllowWritesFromAFollower() throws Exception {
        this.cluster.awaitLeader();
        CoreGraphDatabase follower = this.cluster.getMemberWithRole(Role.FOLLOWER).database();
        try (Transaction tx = follower.beginTx();){
            follower.createNode();
            tx.success();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"No write operations are allowed"));
        }
    }

    @Test
    public void pageFaultsFromReplicationMustCountInMetrics() throws Exception {
        Function<CoreClusterMember, PageCacheCounters> getPageCacheCounters = ccm -> (PageCacheCounters)ccm.database().getDependencyResolver().resolveDependency(PageCacheCounters.class);
        List countersList = this.cluster.coreMembers().stream().map(getPageCacheCounters).collect(Collectors.toList());
        long[] initialPins = countersList.stream().mapToLong(PageCacheCounters::pins).toArray();
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        int minimumUpdatedMembersCount = countersList.size() / 2 + 1;
        org.neo4j.test.assertion.Assert.assertEventually((String)"Expected followers to eventually increase pin counts", () -> {
            long[] pinsAfterCommit = countersList.stream().mapToLong(PageCacheCounters::pins).toArray();
            int membersWithIncreasedPinCount = 0;
            for (int i = 0; i < initialPins.length; ++i) {
                long before = initialPins[i];
                long after = pinsAfterCommit[i];
                if (before >= after) continue;
                ++membersWithIncreasedPinCount;
            }
            return membersWithIncreasedPinCount;
        }, (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(minimumUpdatedMembersCount))), (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldNotAllowSchemaChangesFromAFollower() throws Exception {
        this.cluster.awaitLeader();
        CoreGraphDatabase follower = this.cluster.getMemberWithRole(Role.FOLLOWER).database();
        try (Transaction tx = follower.beginTx();){
            follower.schema().constraintFor(Label.label((String)"Foo")).assertPropertyIsUnique("name").create();
            tx.success();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"No write operations are allowed"));
        }
    }

    @Test
    public void shouldNotAllowTokenCreationFromAFollowerWithNoInitialTokens() throws Exception {
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.createNode();
            tx.success();
        });
        this.awaitForDataToBeApplied(leader);
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        CoreGraphDatabase follower = this.cluster.getMemberWithRole(Role.FOLLOWER).database();
        try (Transaction tx2 = follower.beginTx();){
            ((Node)follower.getAllNodes().iterator().next()).setProperty("name", (Object)"Mark");
            tx2.success();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (WriteOperationsNotAllowedException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"No write operations are allowed"));
        }
    }

    private void awaitForDataToBeApplied(CoreClusterMember leader) throws TimeoutException {
        Predicates.await(() -> DataCreator.countNodes(leader) > 0L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test
    public void shouldReplicateTransactionToCoreMemberAddedAfterInitialStartUp() throws Exception {
        this.cluster.getCoreMemberById(0).shutdown();
        this.cluster.addCoreMemberWithId(3).start();
        this.cluster.getCoreMemberById(0).start();
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.addCoreMemberWithId(4).start();
        CoreClusterMember last = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Assert.assertEquals((long)2L, (long)DataCreator.countNodes(last));
        Cluster.dataMatchesEventually(last, this.cluster.coreMembers());
    }

    @Test
    public void shouldReplicateTransactionAfterLeaderWasRemovedFromCluster() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.removeCoreMember(this.cluster.awaitLeader());
        this.cluster.awaitLeader(1L, TimeUnit.MINUTES);
        CoreClusterMember last = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode();
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Assert.assertEquals((long)2L, (long)DataCreator.countNodes(last));
        Cluster.dataMatchesEventually(last, this.cluster.coreMembers());
    }

    @Test
    public void shouldReplicateToCoreMembersAddedAfterInitialTransactions() throws Exception {
        CoreClusterMember last = null;
        for (int i = 0; i < 15; ++i) {
            last = this.cluster.coreTx((db, tx) -> {
                Node node = db.createNode();
                node.setProperty("foobar", (Object)"baz_bat");
                tx.success();
            });
        }
        this.cluster.addCoreMemberWithId(3).start();
        this.cluster.addCoreMemberWithId(4).start();
        Assert.assertEquals((long)15L, (long)DataCreator.countNodes(last));
        Cluster.dataMatchesEventually(last, this.cluster.coreMembers());
    }

    @Test
    public void shouldReplicateTransactionsToReplacementCoreMembers() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        this.cluster.removeCoreMemberWithServerId(0);
        CoreClusterMember replacement = this.cluster.addCoreMemberWithId(0);
        replacement.start();
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            db.schema().indexFor(Label.label((String)"boo")).on("foobar").create();
            tx.success();
        });
        Assert.assertEquals((long)1L, (long)DataCreator.countNodes(leader));
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
    }

    @Test
    public void shouldBeAbleToShutdownWhenTheLeaderIsTryingToReplicateTransaction() throws Exception {
        this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                this.cluster.coreTx((db, tx) -> {
                    db.createNode();
                    tx.success();
                    this.cluster.removeCoreMember(this.cluster.getMemberWithAnyRole(Role.FOLLOWER, Role.CANDIDATE));
                    this.cluster.removeCoreMember(this.cluster.getMemberWithAnyRole(Role.FOLLOWER, Role.CANDIDATE));
                    latch.countDown();
                });
                Assert.fail((String)"Should have thrown");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        thread.start();
        latch.await();
        this.cluster.shutdown();
        thread.join(TimeUnit.MINUTES.toMillis(1L));
    }
}

