/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.test.causalclustering.ClusterRule;

public class ConsensusGroupSettingsIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(5).withNumberOfReadReplicas(0).withInstanceCoreParam(CausalClusteringSettings.minimum_core_cluster_size_at_formation, value -> "5").withInstanceCoreParam(CausalClusteringSettings.minimum_core_cluster_size_at_runtime, value -> "3").withInstanceCoreParam(CausalClusteringSettings.leader_election_timeout, value -> "1s").withTimeout(1000L, TimeUnit.SECONDS);
    private Cluster<?> cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldNotAllowTheConsensusGroupToDropBelowMinimumConsensusGroupSize() throws Exception {
        int numberOfCoreSeversToRemove = 3;
        this.cluster.awaitLeader();
        for (int i = 0; i < numberOfCoreSeversToRemove; ++i) {
            this.cluster.removeCoreMember(this.cluster.getMemberWithRole(Role.LEADER));
            this.cluster.awaitLeader(30L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((long)3L, (long)this.cluster.coreMembers().iterator().next().raft().replicationMembers().size());
    }
}

