/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.routing.load_balancing.procedure.ProcedureNames;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterDiscoveryIT {
    @Parameterized.Parameter(value=0)
    public String ignored;
    @Parameterized.Parameter(value=1)
    public Map<String, String> config;
    @Parameterized.Parameter(value=2)
    public boolean expectFollowersAsReadEndPoints;
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"with followers as read end points", Collections.singletonMap(CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "true"), true}, {"no followers as read end points", Collections.singletonMap(CausalClusteringSettings.cluster_allow_reads_on_followers.name(), "false"), false});
    }

    @Test
    public void shouldFindReadWriteAndRouteServers() throws Exception {
        Cluster<?> cluster = this.clusterRule.withSharedCoreParams(this.config).withNumberOfReadReplicas(1).startCluster();
        int cores = cluster.coreMembers().size();
        int readReplicas = cluster.readReplicas().size();
        int readEndPoints = this.expectFollowersAsReadEndPoints ? cores - 1 + readReplicas : readReplicas;
        for (int i = 0; i < 3; ++i) {
            List<Map<String, Object>> members = this.getMembers((GraphDatabaseFacade)cluster.getCoreMemberById(i).database());
            Assert.assertEquals((long)1L, (long)members.stream().filter(x -> x.get("role").equals("WRITE")).flatMap(x -> Arrays.stream((Object[])x.get("addresses"))).count());
            Assert.assertEquals((long)readEndPoints, (long)members.stream().filter(x -> x.get("role").equals("READ")).flatMap(x -> Arrays.stream((Object[])x.get("addresses"))).count());
            Assert.assertEquals((long)cores, (long)members.stream().filter(x -> x.get("role").equals("ROUTE")).flatMap(x -> Arrays.stream((Object[])x.get("addresses"))).count());
        }
    }

    @Test
    public void shouldNotBeAbleToDiscoverFromReadReplicas() throws Exception {
        Cluster<?> cluster = this.clusterRule.withSharedCoreParams(this.config).withNumberOfReadReplicas(2).startCluster();
        try {
            this.getMembers((GraphDatabaseFacade)cluster.getReadReplicaById(0).database());
            Assert.fail((String)"Should not be able to discover members from read replicas");
        }
        catch (ProcedureException ex) {
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"There is no procedure with the name"));
        }
    }

    private List<Map<String, Object>> getMembers(GraphDatabaseFacade db) throws TransactionFailureException, ProcedureException {
        Kernel kernel = (Kernel)db.getDependencyResolver().resolveDependency(Kernel.class);
        try (Transaction tx = kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            List currentMembers = Iterators.asList((RawIterator)tx.procedures().procedureCallRead(ProcedureSignature.procedureName((String[])ProcedureNames.GET_SERVERS_V1.fullyQualifiedProcedureName()), new Object[0]));
            List list = (List)((Object[])currentMembers.get(0))[1];
            return list;
        }
    }
}

