/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.util.UUID;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.NoOpHostnameResolver;
import org.neo4j.causalclustering.discovery.TopologyServiceNoRetriesStrategy;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.scheduler.JobScheduler;

public abstract class BaseCoreTopologyServiceIT {
    private final DiscoveryServiceType discoveryServiceType;

    protected BaseCoreTopologyServiceIT(DiscoveryServiceType discoveryServiceType) {
        this.discoveryServiceType = discoveryServiceType;
    }

    @Test(timeout=120000L)
    public void shouldBeAbleToStartAndStopWithoutSuccessfulJoin() throws Throwable {
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        NoOpHostnameResolver hostnameResolver = new NoOpHostnameResolver();
        String initialHosts = "localhost:" + PortAuthority.allocatePort() + ",localhost:" + PortAuthority.allocatePort();
        Config config = Config.defaults();
        config.augment(CausalClusteringSettings.initial_discovery_members, initialHosts);
        config.augment(CausalClusteringSettings.discovery_listen_address, "localhost:" + PortAuthority.allocatePort());
        CoreTopologyService service = this.discoveryServiceType.createFactory().coreTopologyService(config, new MemberId(UUID.randomUUID()), jobScheduler, (LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance(), (HostnameResolver)hostnameResolver, (TopologyServiceRetryStrategy)new TopologyServiceNoRetriesStrategy(), new Monitors());
        service.init();
        service.start();
        service.stop();
        service.shutdown();
    }
}

