/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.helpers.DataCreator;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public abstract class BaseClusterIpFamilyIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3).withNumberOfReadReplicas(3).withSharedCoreParam(CausalClusteringSettings.disable_middleware_logging, "false").withSharedReadReplicaParam(CausalClusteringSettings.disable_middleware_logging, "false").withSharedCoreParam(CausalClusteringSettings.middleware_logging_level, "0").withSharedReadReplicaParam(CausalClusteringSettings.middleware_logging_level, "0");
    private Cluster<?> cluster;

    protected BaseClusterIpFamilyIT(DiscoveryServiceType discoveryServiceType, IpFamily ipFamily, boolean useWildcard) {
        this.clusterRule.withDiscoveryServiceType(discoveryServiceType);
        this.clusterRule.withIpFamily(ipFamily).useWildcard(useWildcard);
    }

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldSetupClusterWithIPv6() throws Exception {
        int numberOfNodes = 10;
        CoreClusterMember leader = DataCreator.createEmptyNodes(this.cluster, numberOfNodes);
        Assert.assertEquals((long)numberOfNodes, (long)DataCreator.countNodes(leader));
        Cluster.dataMatchesEventually(leader, this.cluster.coreMembers());
        Cluster.dataMatchesEventually(leader, this.cluster.readReplicas());
    }
}

