/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.procedure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.TestTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.routing.load_balancing.procedure.LegacyGetServersProcedure;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class GetServersProcedureV1RoutingTest {
    @Parameterized.Parameter
    public int serverClass;
    private ClusterId clusterId = new ClusterId(UUID.randomUUID());
    private Config config = Config.defaults();

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList(1, 2);
    }

    @Test
    public void shouldReturnEndpointsInDifferentOrders() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(0));
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(RaftTestMember.member(0), TestTopology.addressesForCore(0, false));
        coreMembers.put(RaftTestMember.member(1), TestTopology.addressesForCore(1, false));
        coreMembers.put(RaftTestMember.member(2), TestTopology.addressesForCore(2, false));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.localCoreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LegacyGetServersProcedure proc = new LegacyGetServersProcedure((TopologyService)coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        Object[] endpoints = this.getEndpoints(proc);
        Object[] endpointsInDifferentOrder = this.getEndpoints(proc);
        for (int i = 0; i < 100 && Arrays.deepEquals(endpointsInDifferentOrder, endpoints); ++i) {
            endpointsInDifferentOrder = this.getEndpoints(proc);
        }
        Assert.assertFalse((boolean)Arrays.deepEquals(endpoints, endpointsInDifferentOrder));
    }

    private Object[] getEndpoints(LegacyGetServersProcedure proc) throws ProcedureException {
        List results = Iterators.asList((RawIterator)proc.apply(null, new Object[0], null));
        Object[] rows = (Object[])results.get(0);
        List servers = (List)rows[1];
        Map endpoints = (Map)servers.get(this.serverClass);
        return (Object[])endpoints.get("addresses");
    }
}

