/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import co.unruly.matchers.OptionalMatchers;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;
import org.neo4j.helpers.collection.Iterators;

public class ModifierProtocolRepositoryTest {
    @Test
    public void shouldReturnModifierProtocolOfFirstConfiguredVersionRequestedAndSupported() {
        List<ModifierSupportedProtocols> supportedProtocols = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Arrays.asList(TestProtocols.TestModifierProtocols.LZO.implementation(), TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation())), new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.GRATUITOUS_OBFUSCATION, Arrays.asList(TestProtocols.TestModifierProtocols.NAME_CLASH.implementation())));
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), supportedProtocols);
        Optional modifierProtocol = modifierProtocolRepository.select(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])new String[]{"bzip2", TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation(), TestProtocols.TestModifierProtocols.LZO.implementation(), "fast_lz"}));
        Assert.assertThat(modifierProtocol.map(Protocol::implementation), (Matcher)OptionalMatchers.contains((Object)TestProtocols.TestModifierProtocols.LZO.implementation()));
    }

    @Test
    public void shouldReturnModifierProtocolOfSingleConfiguredVersionIfOthersRequested() {
        List<ModifierSupportedProtocols> supportedProtocols = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Arrays.asList(TestProtocols.TestModifierProtocols.LZO.implementation())));
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), supportedProtocols);
        Optional modifierProtocol = modifierProtocolRepository.select(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName(), Iterators.asSet((Object[])TestProtocols.TestModifierProtocols.allVersionsOf(Protocol.ModifierProtocolCategory.COMPRESSION)));
        Assert.assertThat(modifierProtocol.map(Protocol::implementation), (Matcher)OptionalMatchers.contains((Object)TestProtocols.TestModifierProtocols.LZO.implementation()));
    }

    @Test
    public void shouldCompareModifierProtocolsByListOrder() {
        List<ModifierSupportedProtocols> supportedProtocols = Arrays.asList(new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Arrays.asList(TestProtocols.TestModifierProtocols.LZO.implementation(), TestProtocols.TestModifierProtocols.SNAPPY.implementation(), TestProtocols.TestModifierProtocols.LZ4.implementation())));
        Comparator comparator = (Comparator)ModifierProtocolRepository.getModifierProtocolComparator(supportedProtocols).apply(Protocol.ModifierProtocolCategory.COMPRESSION.canonicalName());
        Assert.assertThat((Object)comparator.compare(TestProtocols.TestModifierProtocols.LZO, TestProtocols.TestModifierProtocols.SNAPPY), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)comparator.compare(TestProtocols.TestModifierProtocols.SNAPPY, TestProtocols.TestModifierProtocols.LZ4), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }
}

