/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.net;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.causalclustering.net.BootstrapConfiguration;

class BootstrapConfigurationTest {
    BootstrapConfigurationTest() {
    }

    @Test
    @AssumeEpoll
    void shouldChooseEpollIfAvailable() {
        BootstrapConfiguration cConfig = BootstrapConfiguration.clientConfig((boolean)true);
        BootstrapConfiguration sConfig = BootstrapConfiguration.serverConfig((boolean)true);
        Assertions.assertEquals(EpollSocketChannel.class, (Object)cConfig.channelClass());
        Assertions.assertEquals(EpollServerSocketChannel.class, (Object)sConfig.channelClass());
    }

    @Test
    @AssumeKQueue
    void shouldChooseKqueueIfAvailable() {
        BootstrapConfiguration cConfig = BootstrapConfiguration.clientConfig((boolean)true);
        BootstrapConfiguration sConfig = BootstrapConfiguration.serverConfig((boolean)true);
        Assertions.assertEquals(KQueueSocketChannel.class, (Object)cConfig.channelClass());
        Assertions.assertEquals(KQueueServerSocketChannel.class, (Object)sConfig.channelClass());
    }

    @Test
    @AssumeNoEpollOrKQueue
    void shouldChooseNioIfNoNativeAvailable() {
        BootstrapConfiguration cConfig = BootstrapConfiguration.clientConfig((boolean)true);
        BootstrapConfiguration sConfig = BootstrapConfiguration.serverConfig((boolean)true);
        Assertions.assertEquals(NioSocketChannel.class, (Object)cConfig.channelClass());
        Assertions.assertEquals(NioServerSocketChannel.class, (Object)sConfig.channelClass());
    }

    @Test
    void shouldChooseNioIfNativeIsNotPrefered() {
        BootstrapConfiguration cConfig = BootstrapConfiguration.clientConfig((boolean)false);
        BootstrapConfiguration sConfig = BootstrapConfiguration.serverConfig((boolean)false);
        Assertions.assertEquals(NioSocketChannel.class, (Object)cConfig.channelClass());
        Assertions.assertEquals(NioServerSocketChannel.class, (Object)sConfig.channelClass());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ExtendWith(value={NoEpollOrKqueueCondition.class})
    private static @interface AssumeNoEpollOrKQueue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ExtendWith(value={EpollExecutionCondition.class})
    private static @interface AssumeEpoll {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @ExtendWith(value={KQueueExecutionCondition.class})
    private static @interface AssumeKQueue {
    }

    private static class NoEpollOrKqueueCondition
    implements ExecutionCondition {
        private NoEpollOrKqueueCondition() {
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            return Epoll.isAvailable() || KQueue.isAvailable() ? ConditionEvaluationResult.disabled((String)"Epoll or Kqueue is available") : ConditionEvaluationResult.enabled((String)"Epoll and KQueue is not available");
        }
    }

    private static class EpollExecutionCondition
    implements ExecutionCondition {
        private EpollExecutionCondition() {
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            return Epoll.isAvailable() ? ConditionEvaluationResult.enabled((String)"Epoll is available") : ConditionEvaluationResult.disabled((String)"Epoll is not available");
        }
    }

    private static class KQueueExecutionCondition
    implements ExecutionCondition {
        private KQueueExecutionCondition() {
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            return KQueue.isAvailable() ? ConditionEvaluationResult.enabled((String)"KQueue is available") : ConditionEvaluationResult.disabled((String)"KQueue is not available");
        }
    }
}

