/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.ReferenceCountUtil;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.protocol.v1.RaftProtocolClientInstallerV1;
import org.neo4j.causalclustering.core.consensus.protocol.v1.RaftProtocolServerInstallerV1;
import org.neo4j.causalclustering.core.consensus.protocol.v2.RaftProtocolClientInstallerV2;
import org.neo4j.causalclustering.core.consensus.protocol.v2.RaftProtocolServerInstallerV2;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

@RunWith(value=Parameterized.class)
public class RaftMessageEncoderDecoderTest {
    private static final MemberId MEMBER_ID = new MemberId(UUID.randomUUID());
    private static final int[] PROTOCOLS = new int[]{1, 2};
    @Parameterized.Parameter
    public RaftMessages.RaftMessage raftMessage;
    @Parameterized.Parameter(value=1)
    public int raftProtocol;
    private final RaftMessageHandler handler = new RaftMessageHandler();
    private EmbeddedChannel outbound;
    private EmbeddedChannel inbound;

    @Parameterized.Parameters(name="Raft v{1} with message {0}")
    public static Object[] data() {
        return RaftMessageEncoderDecoderTest.setUpParams(new RaftMessages.RaftMessage[]{new RaftMessages.Heartbeat(MEMBER_ID, 1L, 2L, 3L), new RaftMessages.HeartbeatResponse(MEMBER_ID), new RaftMessages.NewEntry.Request(MEMBER_ID, (ReplicatedContent)new DummyRequest(new byte[]{1, 2, 3, 4, 5, 6, 7, 8})), new RaftMessages.NewEntry.Request(MEMBER_ID, (ReplicatedContent)ReplicatedTransaction.from((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8})), new RaftMessages.NewEntry.Request(MEMBER_ID, (ReplicatedContent)ReplicatedTransaction.from((TransactionRepresentation)new PhysicalTransactionRepresentation(Collections.emptyList()))), new RaftMessages.NewEntry.Request(MEMBER_ID, (ReplicatedContent)new DistributedOperation((ReplicatedContent)new DistributedOperation((ReplicatedContent)ReplicatedTransaction.from((byte[])new byte[]{1, 2, 3, 4, 5}), new GlobalSession(UUID.randomUUID(), MEMBER_ID), new LocalOperationId(1L, 2L)), new GlobalSession(UUID.randomUUID(), MEMBER_ID), new LocalOperationId(3L, 4L))), new RaftMessages.AppendEntries.Request(MEMBER_ID, 1L, 2L, 3L, new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new ReplicatedTokenRequest(TokenType.LABEL, "name", new byte[]{2, 3, 4})), new RaftLogEntry(1L, (ReplicatedContent)new ReplicatedLockTokenRequest(MEMBER_ID, 2))}, 5L), new RaftMessages.AppendEntries.Response(MEMBER_ID, 1L, true, 2L, 3L), new RaftMessages.Vote.Request(MEMBER_ID, Long.MAX_VALUE, MEMBER_ID, Long.MIN_VALUE, 1L), new RaftMessages.Vote.Response(MEMBER_ID, 1L, true), new RaftMessages.PreVote.Request(MEMBER_ID, Long.MAX_VALUE, MEMBER_ID, Long.MIN_VALUE, 1L), new RaftMessages.PreVote.Response(MEMBER_ID, 1L, true), new RaftMessages.LogCompactionInfo(MEMBER_ID, Long.MAX_VALUE, Long.MIN_VALUE)});
    }

    private static Object[] setUpParams(RaftMessages.RaftMessage[] messages) {
        return Arrays.stream(messages).flatMap(RaftMessageEncoderDecoderTest::params).toArray();
    }

    private static Stream<Object[]> params(RaftMessages.RaftMessage raftMessage) {
        return Arrays.stream(PROTOCOLS).mapToObj(p -> new Object[]{raftMessage, p});
    }

    @Before
    public void setupChannels() throws Exception {
        this.outbound = new EmbeddedChannel();
        this.inbound = new EmbeddedChannel();
        if (this.raftProtocol == 2) {
            new RaftProtocolClientInstallerV2(new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER), Collections.emptyList(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).install((Channel)this.outbound);
            new RaftProtocolServerInstallerV2((ChannelInboundHandler)this.handler, new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER), Collections.emptyList(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).install((Channel)this.inbound);
        } else if (this.raftProtocol == 1) {
            new RaftProtocolClientInstallerV1(new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER), Collections.emptyList(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).install((Channel)this.outbound);
            new RaftProtocolServerInstallerV1((ChannelInboundHandler)this.handler, new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER), Collections.emptyList(), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out)).install((Channel)this.inbound);
        } else {
            throw new IllegalArgumentException("Unknown raft protocol " + this.raftProtocol);
        }
    }

    @After
    public void cleanUp() {
        if (this.outbound != null) {
            this.outbound.close();
        }
        if (this.inbound != null) {
            this.inbound.close();
        }
        this.inbound = null;
        this.outbound = null;
    }

    @Test
    public void shouldEncodeDecodeRaftMessage() throws Exception {
        Object o;
        ClusterId clusterId = new ClusterId(UUID.randomUUID());
        RaftMessages.ReceivedInstantClusterIdAwareMessage idAwareMessage = RaftMessages.ReceivedInstantClusterIdAwareMessage.of((Instant)Instant.now(), (ClusterId)clusterId, (RaftMessages.RaftMessage)this.raftMessage);
        this.outbound.writeOutbound(new Object[]{idAwareMessage});
        while ((o = this.outbound.readOutbound()) != null) {
            this.inbound.writeInbound(new Object[]{o});
        }
        RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> message = this.handler.getRaftMessage();
        Assert.assertEquals((Object)clusterId, (Object)message.clusterId());
        this.raftMessageEquals(this.raftMessage, message.message());
        Assert.assertNull((Object)this.inbound.readInbound());
        ReferenceCountUtil.release((Object)this.handler.msg);
    }

    private void raftMessageEquals(RaftMessages.RaftMessage raftMessage, RaftMessages.RaftMessage message) throws Exception {
        if (raftMessage instanceof RaftMessages.NewEntry.Request) {
            Assert.assertEquals((Object)message.from(), (Object)raftMessage.from());
            Assert.assertEquals((Object)message.type(), (Object)raftMessage.type());
            this.contentEquals(((RaftMessages.NewEntry.Request)raftMessage).content(), ((RaftMessages.NewEntry.Request)raftMessage).content());
        } else if (raftMessage instanceof RaftMessages.AppendEntries.Request) {
            Assert.assertEquals((Object)message.from(), (Object)raftMessage.from());
            Assert.assertEquals((Object)message.type(), (Object)raftMessage.type());
            RaftLogEntry[] entries1 = ((RaftMessages.AppendEntries.Request)raftMessage).entries();
            RaftLogEntry[] entries2 = ((RaftMessages.AppendEntries.Request)message).entries();
            for (int i = 0; i < entries1.length; ++i) {
                RaftLogEntry raftLogEntry1 = entries1[i];
                RaftLogEntry raftLogEntry2 = entries2[i];
                Assert.assertEquals((long)raftLogEntry1.term(), (long)raftLogEntry2.term());
                this.contentEquals(raftLogEntry1.content(), raftLogEntry2.content());
            }
        }
    }

    private void contentEquals(ReplicatedContent one, ReplicatedContent two) throws Exception {
        if (one instanceof ReplicatedTransaction) {
            ByteBuf buffer1 = Unpooled.buffer();
            ByteBuf buffer2 = Unpooled.buffer();
            RaftMessageEncoderDecoderTest.encode(buffer1, (ChunkedInput<ByteBuf>)((ReplicatedTransaction)one).encode());
            RaftMessageEncoderDecoderTest.encode(buffer2, (ChunkedInput<ByteBuf>)((ReplicatedTransaction)two).encode());
            Assert.assertEquals((Object)buffer1, (Object)buffer2);
        } else if (one instanceof DistributedOperation) {
            Assert.assertEquals((Object)((DistributedOperation)one).globalSession(), (Object)((DistributedOperation)two).globalSession());
            Assert.assertEquals((Object)((DistributedOperation)one).operationId(), (Object)((DistributedOperation)two).operationId());
            this.contentEquals(((DistributedOperation)one).content(), ((DistributedOperation)two).content());
        } else {
            Assert.assertEquals((Object)one, (Object)two);
        }
    }

    private static void encode(ByteBuf buffer, ChunkedInput<ByteBuf> marshal) throws Exception {
        while (!marshal.isEndOfInput()) {
            ByteBuf tmp = (ByteBuf)marshal.readChunk((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            if (tmp == null) continue;
            buffer.writeBytes(tmp);
            tmp.release();
        }
    }

    class RaftMessageHandler
    extends SimpleChannelInboundHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage>> {
        private RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> msg;

        RaftMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> msg) {
            this.msg = msg;
        }

        RaftMessages.ReceivedInstantClusterIdAwareMessage<RaftMessages.RaftMessage> getRaftMessage() {
            return this.msg;
        }
    }
}

