/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.messaging.MessageGate;
import org.neo4j.causalclustering.protocol.handshake.GateEvent;

public class MessageGateTest {
    private final String ALLOWED_MSG = "allowed";
    private final MessageGate gate = new MessageGate(m -> m != "allowed");
    private final ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    private final Channel channel = (Channel)Mockito.mock(Channel.class);
    private final ChannelPipeline pipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.channel.pipeline()).thenReturn((Object)this.pipeline);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
    }

    @Test
    public void shouldLetAllowedMessagesPass() throws Exception {
        ChannelPromise promise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        this.gate.write(this.ctx, (Object)"allowed", promise);
        this.gate.write(this.ctx, (Object)"allowed", promise);
        this.gate.write(this.ctx, (Object)"allowed", promise);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)3))).write((Object)"allowed", promise);
    }

    @Test
    public void shouldGateMessages() throws Exception {
        ChannelPromise promise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        this.gate.write(this.ctx, (Object)"A", promise);
        this.gate.write(this.ctx, (Object)"B", promise);
        this.gate.write(this.ctx, (Object)"C", promise);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).write(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
    }

    @Test
    public void shouldLetGatedMessagesPassOnSuccess() throws Exception {
        ChannelPromise promiseA = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        ChannelPromise promiseB = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        ChannelPromise promiseC = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        this.gate.write(this.ctx, (Object)"A", promiseA);
        this.gate.write(this.ctx, (Object)"B", promiseB);
        this.gate.write(this.ctx, (Object)"C", promiseC);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).write(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
        this.gate.userEventTriggered(this.ctx, (Object)GateEvent.getSuccess());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.ctx});
        ((ChannelHandlerContext)inOrder.verify((Object)this.ctx)).write((Object)"A", promiseA);
        ((ChannelHandlerContext)inOrder.verify((Object)this.ctx)).write((Object)"B", promiseB);
        ((ChannelHandlerContext)inOrder.verify((Object)this.ctx)).write((Object)"C", promiseC);
        ((ChannelHandlerContext)inOrder.verify((Object)this.ctx, Mockito.never())).write(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
    }

    @Test
    public void shouldRemoveGateOnSuccess() throws Exception {
        this.gate.userEventTriggered(this.ctx, (Object)GateEvent.getSuccess());
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).remove((ChannelHandler)this.gate);
    }

    @Test
    public void shouldNotLetGatedMessagesPassAfterFailure() throws Exception {
        ChannelPromise promise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        this.gate.userEventTriggered(this.ctx, (Object)GateEvent.getFailure());
        this.gate.write(this.ctx, (Object)"A", promise);
        this.gate.write(this.ctx, (Object)"B", promise);
        this.gate.write(this.ctx, (Object)"C", promise);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).write(ArgumentMatchers.any(), (ChannelPromise)ArgumentMatchers.any());
    }

    @Test
    public void shouldStillLetAllowedMessagePassAfterFailure() throws Exception {
        ChannelPromise promise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        this.gate.userEventTriggered(this.ctx, (Object)GateEvent.getFailure());
        this.gate.write(this.ctx, (Object)"allowed", promise);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).write((Object)"allowed", promise);
    }

    @Test
    public void shouldLeaveGateOnFailure() throws Exception {
        this.gate.userEventTriggered(this.ctx, (Object)GateEvent.getFailure());
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline, (VerificationMode)Mockito.never())).remove((ChannelHandler)ArgumentMatchers.any(ChannelHandler.class));
    }
}

