/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.LinkedList;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.causalclustering.helpers.Buffers;
import org.neo4j.causalclustering.messaging.ChunkingNetworkChannel;

public class ChunkingNetworkChannelTest {
    @Rule
    public final Buffers buffers = new Buffers();

    @Test
    public void shouldSerializeIntoChunksOfGivenSize() {
        ByteBuf byteBuf;
        int chunkSize = 8;
        LinkedList byteBufs = new LinkedList();
        ChunkingNetworkChannel channel = new ChunkingNetworkChannel((ByteBufAllocator)this.buffers, chunkSize, byteBufs);
        byte[] array = new byte[10];
        channel.put((byte)1);
        channel.putInt(1);
        channel.putFloat(1.0f);
        channel.putDouble(1.0);
        channel.putShort((short)1);
        channel.putLong(1L);
        channel.put(array, array.length);
        channel.flush();
        ByteBuf combinedByteBuf = this.buffers.buffer();
        while ((byteBuf = (ByteBuf)byteBufs.poll()) != null) {
            Assertions.assertEquals((int)chunkSize, (int)byteBuf.capacity());
            combinedByteBuf.writeBytes(byteBuf);
        }
        Assertions.assertEquals((byte)1, (byte)combinedByteBuf.readByte());
        Assertions.assertEquals((int)1, (int)combinedByteBuf.readInt());
        Assertions.assertEquals((float)1.0f, (float)combinedByteBuf.readFloat());
        Assertions.assertEquals((double)1.0, (double)combinedByteBuf.readDouble());
        Assertions.assertEquals((short)1, (short)combinedByteBuf.readShort());
        Assertions.assertEquals((long)1L, (long)combinedByteBuf.readLong());
        byte[] bytes = new byte[array.length];
        combinedByteBuf.readBytes(bytes);
        Assertions.assertArrayEquals((byte[])array, (byte[])bytes);
        Assertions.assertEquals((int)0, (int)combinedByteBuf.readableBytes());
    }

    @Test
    public void shouldReturnNullIfQueueIsEmpty() {
        int chunkSize = 8;
        LinkedList byteBufs = new LinkedList();
        ChunkingNetworkChannel channel = new ChunkingNetworkChannel((ByteBufAllocator)this.buffers, chunkSize, byteBufs);
        channel.putLong(1L);
        channel.putLong(1L);
        Assertions.assertNotNull(byteBufs.poll());
        Assertions.assertNull(byteBufs.poll());
        channel.putLong(2L);
        Assertions.assertNotNull(byteBufs.poll());
        Assertions.assertNull(byteBufs.poll());
        channel.flush();
        Assertions.assertNotNull(byteBufs.poll());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStatAfterClosed() {
        int chunkSize = 8;
        ChunkingNetworkChannel channel = new ChunkingNetworkChannel((ByteBufAllocator)this.buffers, chunkSize, new LinkedList());
        channel.close();
        channel.putInt(1);
    }
}

