/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.messaging.BoundedNetworkWritableChannel;
import org.neo4j.causalclustering.messaging.MessageTooBigException;

public class BoundedNetworkWritableChannelTest {
    @Test
    public void shouldRespectSizeLimit() throws Exception {
        int sizeLimit = 100;
        BoundedNetworkWritableChannel channel = new BoundedNetworkWritableChannel(Unpooled.buffer(), (long)sizeLimit);
        for (int i = 0; i < sizeLimit; ++i) {
            channel.put((byte)1);
        }
        try {
            channel.put((byte)1);
            Assert.fail((String)"Should not allow more bytes than what the limit dictates");
        }
        catch (MessageTooBigException messageTooBigException) {
            // empty catch block
        }
    }

    @Test
    public void sizeLimitShouldWorkWithArrays() throws Exception {
        int sizeLimit = 100;
        BoundedNetworkWritableChannel channel = new BoundedNetworkWritableChannel(Unpooled.buffer(), (long)sizeLimit);
        int padding = 10;
        for (int i = 0; i < sizeLimit - padding; ++i) {
            channel.put((byte)0);
        }
        try {
            channel.put(new byte[padding * 2], padding * 2);
            Assert.fail((String)"Should not allow more bytes than what the limit dictates");
        }
        catch (MessageTooBigException messageTooBigException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotCountBytesAlreadyInBuffer() throws Exception {
        int i;
        int sizeLimit = 100;
        ByteBuf buffer = Unpooled.buffer();
        int padding = 8;
        buffer.writeLong(0L);
        BoundedNetworkWritableChannel channel = new BoundedNetworkWritableChannel(buffer, (long)sizeLimit);
        for (i = 0; i < sizeLimit - padding; ++i) {
            channel.put((byte)0);
        }
        for (i = 0; i < padding; ++i) {
            channel.put((byte)0);
        }
        try {
            channel.put((byte)0);
            Assert.fail((String)"Should not allow more bytes than what the limit dictates");
        }
        catch (MessageTooBigException messageTooBigException) {
            // empty catch block
        }
    }
}

