/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import com.hazelcast.core.OperationTimeoutException;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.storage.SimpleStorage;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.TestTopology;
import org.neo4j.causalclustering.identity.BindingException;
import org.neo4j.causalclustering.identity.BoundState;
import org.neo4j.causalclustering.identity.ClusterBinder;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class ClusterBinderTest {
    private final CoreBootstrapper coreBootstrapper = (CoreBootstrapper)Mockito.mock(CoreBootstrapper.class);
    private final FakeClock clock = Clocks.fakeClock();
    private final Config config = Config.defaults();
    private final int minCoreHosts = (Integer)this.config.get(CausalClusteringSettings.minimum_core_cluster_size_at_formation);
    private final String dbName = (String)this.config.get(CausalClusteringSettings.database);

    private ClusterBinder clusterBinder(SimpleStorage<ClusterId> clusterIdStorage, CoreTopologyService topologyService) {
        return new ClusterBinder(clusterIdStorage, new StubSimpleStorage(), topologyService, (Clock)this.clock, () -> this.clock.forward(1L, TimeUnit.SECONDS), Duration.of(3000L, ChronoUnit.MILLIS), this.coreBootstrapper, this.dbName, this.minCoreHosts, new Monitors());
    }

    @Test
    public void shouldRetryWhenPublishFailsWithTransientErrors() throws Throwable {
        Map<MemberId, CoreServerInfo> members = IntStream.range(0, this.minCoreHosts).mapToObj(i -> Pair.of((Object)new MemberId(UUID.randomUUID()), (Object)TestTopology.addressesForCore(i, false))).collect(Collectors.toMap(Pair::first, Pair::other));
        CoreTopology bootstrappableTopology = new CoreTopology(null, true, members);
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.setClusterId((ClusterId)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenThrow(OperationTimeoutException.class).thenReturn((Object)true);
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)bootstrappableTopology);
        ClusterBinder binder = this.clusterBinder(new StubSimpleStorage<ClusterId>(), topologyService);
        binder.bindToCluster();
        ((CoreTopologyService)Mockito.verify((Object)topologyService, (VerificationMode)Mockito.atLeast((int)2))).setClusterId((ClusterId)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test(expected=TimeoutException.class)
    public void shouldTimeoutIfPublishContinuallyFailsWithTransientErrors() throws Throwable {
        Map<MemberId, CoreServerInfo> members = IntStream.range(0, this.minCoreHosts).mapToObj(i -> Pair.of((Object)new MemberId(UUID.randomUUID()), (Object)TestTopology.addressesForCore(i, false))).collect(Collectors.toMap(Pair::first, Pair::other));
        CoreTopology bootstrappableTopology = new CoreTopology(null, true, members);
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.setClusterId((ClusterId)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenThrow(OperationTimeoutException.class);
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)bootstrappableTopology);
        ClusterBinder binder = this.clusterBinder(new StubSimpleStorage<ClusterId>(), topologyService);
        binder.bindToCluster();
    }

    @Test
    public void shouldTimeoutWhenNotBootstrappableAndNobodyElsePublishesClusterId() throws Throwable {
        CoreTopology unboundTopology = new CoreTopology(null, false, Collections.emptyMap());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)unboundTopology);
        ClusterBinder binder = this.clusterBinder(new StubSimpleStorage<ClusterId>(), topologyService);
        try {
            binder.bindToCluster();
            Assert.fail((String)"Should have timed out");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        ((CoreTopologyService)Mockito.verify((Object)topologyService, (VerificationMode)Mockito.atLeast((int)2))).localCoreServers();
    }

    @Test
    public void shouldBindToClusterIdPublishedByAnotherMember() throws Throwable {
        ClusterId publishedClusterId = new ClusterId(UUID.randomUUID());
        CoreTopology unboundTopology = new CoreTopology(null, false, Collections.emptyMap());
        CoreTopology boundTopology = new CoreTopology(publishedClusterId, false, Collections.emptyMap());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)unboundTopology).thenReturn((Object)boundTopology);
        ClusterBinder binder = this.clusterBinder(new StubSimpleStorage<ClusterId>(), topologyService);
        binder.bindToCluster();
        Optional clusterId = binder.get();
        Assert.assertTrue((boolean)clusterId.isPresent());
        Assert.assertEquals((Object)publishedClusterId, clusterId.get());
        ((CoreTopologyService)Mockito.verify((Object)topologyService, (VerificationMode)Mockito.atLeast((int)2))).localCoreServers();
    }

    @Test
    public void shouldPublishStoredClusterIdIfPreviouslyBound() throws Throwable {
        ClusterId previouslyBoundClusterId = new ClusterId(UUID.randomUUID());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.setClusterId(previouslyBoundClusterId, "default")).thenReturn((Object)true);
        StubSimpleStorage<ClusterId> clusterIdStorage = new StubSimpleStorage<ClusterId>();
        clusterIdStorage.writeState(previouslyBoundClusterId);
        ClusterBinder binder = this.clusterBinder(clusterIdStorage, topologyService);
        binder.bindToCluster();
        ((CoreTopologyService)Mockito.verify((Object)topologyService)).setClusterId(previouslyBoundClusterId, "default");
        Optional clusterId = binder.get();
        Assert.assertTrue((boolean)clusterId.isPresent());
        Assert.assertEquals((Object)previouslyBoundClusterId, clusterId.get());
    }

    @Test
    public void shouldFailToPublishMismatchingStoredClusterId() throws Throwable {
        ClusterId previouslyBoundClusterId = new ClusterId(UUID.randomUUID());
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.setClusterId(previouslyBoundClusterId, "default")).thenReturn((Object)false);
        StubSimpleStorage<ClusterId> clusterIdStorage = new StubSimpleStorage<ClusterId>();
        clusterIdStorage.writeState(previouslyBoundClusterId);
        ClusterBinder binder = this.clusterBinder(clusterIdStorage, topologyService);
        try {
            binder.bindToCluster();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    @Test
    public void shouldBootstrapWhenBootstrappable() throws Throwable {
        Map<MemberId, CoreServerInfo> members = IntStream.range(0, this.minCoreHosts).mapToObj(i -> Pair.of((Object)new MemberId(UUID.randomUUID()), (Object)TestTopology.addressesForCore(i, false))).collect(Collectors.toMap(Pair::first, Pair::other));
        CoreTopology bootstrappableTopology = new CoreTopology(null, true, members);
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)bootstrappableTopology);
        Mockito.when((Object)topologyService.setClusterId((ClusterId)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"default"))).thenReturn((Object)true);
        CoreSnapshot snapshot = (CoreSnapshot)Mockito.mock(CoreSnapshot.class);
        Mockito.when((Object)this.coreBootstrapper.bootstrap((Set)ArgumentMatchers.any())).thenReturn((Object)snapshot);
        ClusterBinder binder = this.clusterBinder(new StubSimpleStorage<ClusterId>(), topologyService);
        BoundState boundState = binder.bindToCluster();
        ((CoreBootstrapper)Mockito.verify((Object)this.coreBootstrapper)).bootstrap((Set)ArgumentMatchers.any());
        Optional clusterId = binder.get();
        Assert.assertTrue((boolean)clusterId.isPresent());
        ((CoreTopologyService)Mockito.verify((Object)topologyService)).setClusterId((ClusterId)clusterId.get(), "default");
        Assert.assertTrue((boolean)boundState.snapshot().isPresent());
        Assert.assertEquals(boundState.snapshot().get(), (Object)snapshot);
    }

    private class StubSimpleStorage<T>
    implements SimpleStorage<T> {
        private T state;

        private StubSimpleStorage() {
        }

        public boolean exists() {
            return this.state != null;
        }

        public T readState() {
            return this.state;
        }

        public void writeState(T state) {
            this.state = state;
        }
    }
}

