/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helpers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ReferenceCounted;
import java.util.LinkedList;
import java.util.List;
import org.junit.rules.ExternalResource;

public class Buffers
extends ExternalResource
implements ByteBufAllocator {
    private final ByteBufAllocator allocator;
    private final List<ByteBuf> buffersList = new LinkedList<ByteBuf>();

    public Buffers(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public Buffers() {
        this((ByteBufAllocator)new UnpooledByteBufAllocator(false));
    }

    public <BUFFER extends ByteBuf> BUFFER add(BUFFER byteBuf) {
        this.buffersList.add(byteBuf);
        return byteBuf;
    }

    public ByteBuf buffer() {
        return this.add(this.allocator.buffer());
    }

    public ByteBuf buffer(int initialCapacity) {
        return this.add(this.allocator.buffer(initialCapacity));
    }

    public ByteBuf buffer(int initialCapacity, int maxCapacity) {
        return this.add(this.allocator.buffer(initialCapacity, maxCapacity));
    }

    public ByteBuf ioBuffer() {
        return this.add(this.allocator.ioBuffer());
    }

    public ByteBuf ioBuffer(int initialCapacity) {
        return this.add(this.allocator.ioBuffer(initialCapacity));
    }

    public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
        return this.add(this.allocator.ioBuffer(initialCapacity, maxCapacity));
    }

    public ByteBuf heapBuffer() {
        return this.add(this.allocator.heapBuffer());
    }

    public ByteBuf heapBuffer(int initialCapacity) {
        return this.add(this.allocator.heapBuffer(initialCapacity));
    }

    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        return this.add(this.allocator.heapBuffer(initialCapacity, maxCapacity));
    }

    public ByteBuf directBuffer() {
        return this.add(this.allocator.directBuffer());
    }

    public ByteBuf directBuffer(int initialCapacity) {
        return this.add(this.allocator.directBuffer(initialCapacity));
    }

    public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
        return this.add(this.allocator.directBuffer(initialCapacity, maxCapacity));
    }

    public CompositeByteBuf compositeBuffer() {
        return this.add(this.allocator.compositeBuffer());
    }

    public CompositeByteBuf compositeBuffer(int maxNumComponents) {
        return this.add(this.allocator.compositeBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeHeapBuffer() {
        return this.add(this.allocator.compositeHeapBuffer());
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.add(this.allocator.compositeHeapBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeDirectBuffer() {
        return this.add(this.allocator.compositeDirectBuffer());
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.add(this.allocator.compositeBuffer(maxNumComponents));
    }

    public boolean isDirectBufferPooled() {
        return this.allocator.isDirectBufferPooled();
    }

    public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
        return this.allocator.calculateNewCapacity(minNewCapacity, maxCapacity);
    }

    protected void before() {
        this.buffersList.removeIf(buf -> buf.refCnt() == 0);
    }

    protected void after() {
        this.buffersList.forEach(ReferenceCounted::release);
    }
}

