/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.helper.Limiters;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class LimitersTest {
    private final Duration ETERNITY = Duration.ofDays(1000L);

    @Test
    public void shouldRateLimitCalls() {
        int intervalMillis = 10;
        FakeClock clock = Clocks.fakeClock();
        Consumer cap = Limiters.rateLimiter((Duration)Duration.ofMillis(intervalMillis), (Clock)clock);
        AtomicInteger cnt = new AtomicInteger();
        Runnable op = cnt::incrementAndGet;
        cap.accept(op);
        cap.accept(op);
        cap.accept(op);
        Assert.assertThat((Object)cnt.get(), (Matcher)Matchers.equalTo((Object)1));
        clock.forward((long)intervalMillis, TimeUnit.MILLISECONDS);
        cap.accept(op);
        cap.accept(op);
        cap.accept(op);
        Assert.assertThat((Object)cnt.get(), (Matcher)Matchers.equalTo((Object)2));
        clock.forward((long)(1000 * intervalMillis), TimeUnit.MILLISECONDS);
        cap.accept(op);
        cap.accept(op);
        cap.accept(op);
        Assert.assertThat((Object)cnt.get(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void shouldOnlyAllowOneThreadPerInterval() throws Exception {
        int intervalMillis = 10;
        int nThreads = 10;
        int iterations = 100;
        FakeClock clock = Clocks.fakeClock();
        Consumer cap = Limiters.rateLimiter((Duration)Duration.ofMillis(intervalMillis), (Clock)clock);
        AtomicInteger cnt = new AtomicInteger();
        Runnable op = cnt::incrementAndGet;
        for (int iteration = 1; iteration <= iterations; ++iteration) {
            clock.forward((long)intervalMillis, TimeUnit.MILLISECONDS);
            CountDownLatch latch = new CountDownLatch(1);
            ExecutorService es = Executors.newCachedThreadPool();
            for (int j = 0; j < nThreads; ++j) {
                es.submit(() -> {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    cap.accept(op);
                });
            }
            latch.countDown();
            es.shutdown();
            es.awaitTermination(10L, TimeUnit.SECONDS);
            Assert.assertThat((Object)cnt.get(), (Matcher)Matchers.equalTo((Object)iteration));
        }
    }

    @Test
    public void distinctRateLimitersOperateIndependently() throws Exception {
        Limiters limiters = new Limiters((Clock)Clocks.fakeClock());
        AtomicInteger cnt = new AtomicInteger();
        Consumer rateLimiterA = limiters.rateLimiter((Object)"A", this.ETERNITY);
        Consumer rateLimiterB = limiters.rateLimiter((Object)"B", this.ETERNITY);
        rateLimiterA.accept(cnt::incrementAndGet);
        rateLimiterA.accept(cnt::incrementAndGet);
        rateLimiterA.accept(cnt::incrementAndGet);
        rateLimiterB.accept(cnt::incrementAndGet);
        rateLimiterB.accept(cnt::incrementAndGet);
        rateLimiterB.accept(cnt::incrementAndGet);
        Assert.assertEquals((long)2L, (long)cnt.get());
    }

    @Test
    public void shouldReturnSameRateLimiterForSameHandle() throws Exception {
        Limiters limiters = new Limiters((Clock)Clocks.fakeClock());
        AtomicInteger cnt = new AtomicInteger();
        Consumer rateLimiterA = limiters.rateLimiter((Object)"SAME", this.ETERNITY);
        Consumer rateLimiterB = limiters.rateLimiter((Object)"SAME", this.ETERNITY);
        rateLimiterA.accept(cnt::incrementAndGet);
        rateLimiterA.accept(cnt::incrementAndGet);
        rateLimiterB.accept(cnt::incrementAndGet);
        rateLimiterB.accept(cnt::incrementAndGet);
        Assert.assertEquals((long)1L, (long)cnt.get());
    }
}

