/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.helper.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.helper.TimeoutStrategy;

public class ExponentialBackoffStrategyTest {
    private static final int NUMBER_OF_ACCESSES = 5;

    @Test
    public void shouldDoubleEachTime() {
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, 32L, TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assert.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    public void shouldProvidePreviousTimeout() {
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, 32L, TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assert.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    public void shouldRespectUpperBound() {
        long upperBound = 27L;
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, upperBound, TimeUnit.MILLISECONDS);
        TimeoutStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assert.assertEquals((long)upperBound, (long)timeout.getMillis());
        timeout.increment();
        timeout.increment();
        timeout.increment();
        Assert.assertEquals((long)upperBound, (long)timeout.getMillis());
    }
}

