/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;

public class TestTopology {
    private TestTopology() {
    }

    private static ClientConnectorAddresses wrapAsClientConnectorAddresses(AdvertisedSocketAddress advertisedSocketAddress) {
        return new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, advertisedSocketAddress)));
    }

    public static CoreServerInfo addressesForCore(int id, boolean refuseToBeLeader) {
        AdvertisedSocketAddress raftServerAddress = new AdvertisedSocketAddress("localhost", 3000 + id);
        AdvertisedSocketAddress catchupServerAddress = new AdvertisedSocketAddress("localhost", 4000 + id);
        AdvertisedSocketAddress boltServerAddress = new AdvertisedSocketAddress("localhost", 5000 + id);
        return new CoreServerInfo(raftServerAddress, catchupServerAddress, TestTopology.wrapAsClientConnectorAddresses(boltServerAddress), Iterators.asSet((Object[])new String[]{"core", "core" + id}), "default", refuseToBeLeader);
    }

    public static Config configFor(CoreServerInfo coreServerInfo) {
        return Config.builder().withSetting(CausalClusteringSettings.raft_advertised_address, coreServerInfo.getRaftServer().toString()).withSetting(CausalClusteringSettings.transaction_advertised_address, coreServerInfo.getCatchupServer().toString()).withSetting("dbms.connector.bolt.listen_address", coreServerInfo.connectors().boltAddress().toString()).withSetting("dbms.connector.bolt.enabled", String.valueOf(true)).withSetting(CausalClusteringSettings.database, coreServerInfo.getDatabaseName()).withSetting(CausalClusteringSettings.server_groups, String.join((CharSequence)",", coreServerInfo.groups())).withSetting(CausalClusteringSettings.refuse_to_be_leader, String.valueOf(coreServerInfo.refusesToBeLeader())).build();
    }

    public static Config configFor(ReadReplicaInfo readReplicaInfo) {
        return Config.builder().withSetting("dbms.connector.bolt.listen_address", readReplicaInfo.connectors().boltAddress().toString()).withSetting("dbms.connector.bolt.enabled", String.valueOf(true)).withSetting(CausalClusteringSettings.transaction_advertised_address, readReplicaInfo.getCatchupServer().toString()).withSetting(CausalClusteringSettings.server_groups, String.join((CharSequence)",", readReplicaInfo.groups())).withSetting(CausalClusteringSettings.database, readReplicaInfo.getDatabaseName()).build();
    }

    public static ReadReplicaInfo addressesForReadReplica(int id) {
        AdvertisedSocketAddress clientConnectorSocketAddress = new AdvertisedSocketAddress("localhost", 6000 + id);
        ClientConnectorAddresses clientConnectorAddresses = new ClientConnectorAddresses(Collections.singletonList(new ClientConnectorAddresses.ConnectorUri(ClientConnectorAddresses.Scheme.bolt, clientConnectorSocketAddress)));
        AdvertisedSocketAddress catchupSocketAddress = new AdvertisedSocketAddress("localhost", 4000 + id);
        return new ReadReplicaInfo(clientConnectorAddresses, catchupSocketAddress, Iterators.asSet((Object[])new String[]{"replica", "replica" + id}), "default");
    }

    public static Map<MemberId, ReadReplicaInfo> readReplicaInfoMap(int ... ids) {
        return Arrays.stream(ids).mapToObj(TestTopology::addressesForReadReplica).collect(Collectors.toMap(p -> new MemberId(UUID.randomUUID()), Function.identity()));
    }
}

