/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.MockSrvRecordResolver;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.causalclustering.discovery.MultiRetryStrategyTest;
import org.neo4j.causalclustering.discovery.SrvHostnameResolver;
import org.neo4j.causalclustering.discovery.SrvRecordResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class SrvHostnameResolverTest {
    private final MockSrvRecordResolver mockSrvRecordResolver = new MockSrvRecordResolver(new HashMap<String, List<SrvRecordResolver.SrvRecord>>(){
        {
            this.put("emptyrecord.com", new ArrayList());
        }
    });
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final Config config = Config.defaults((Setting)CausalClusteringSettings.minimum_core_cluster_size_at_formation, (String)"2");
    private final SrvHostnameResolver resolver = new SrvHostnameResolver((LogProvider)this.logProvider, (LogProvider)this.userLogProvider, (SrvRecordResolver)this.mockSrvRecordResolver, this.config, this.testRetryStrategy(1));

    @Test
    public void hostnamesAndPortsAreResolvedByTheResolver() {
        this.mockSrvRecordResolver.addRecords("_discovery._tcp.google.com", Arrays.asList(SrvRecordResolver.SrvRecord.parse((String)"1 1 80 1.2.3.4"), SrvRecordResolver.SrvRecord.parse((String)"1 1 8080 5.6.7.8")));
        Collection resolvedAddresses = this.resolver.resolve(new AdvertisedSocketAddress("_discovery._tcp.google.com", 0));
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("1.2.3.4") && address.getPort() == 80));
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("5.6.7.8") && address.getPort() == 8080));
    }

    @Test
    public void resolutionDetailsAreLoggedToUserLogs() {
        this.mockSrvRecordResolver.addRecord("_resolutionDetailsAreLoggedToUserLogs._test.neo4j.com", SrvRecordResolver.SrvRecord.parse((String)"1 1 4321 1.2.3.4"));
        this.resolver.resolve(new AdvertisedSocketAddress("_resolutionDetailsAreLoggedToUserLogs._test.neo4j.com", 0));
        this.userLogProvider.assertContainsMessageContaining("Resolved initial host '%s' to %s");
    }

    @Test
    public void unknownHostExceptionsAreLoggedAsErrors() {
        this.resolver.resolve(new AdvertisedSocketAddress("unknown.com", 0));
        this.logProvider.assertContainsMessageContaining("Failed to resolve srv records for '%s'");
    }

    @Test
    public void emptyRecordListsAreLoggedAsErrors() {
        this.resolver.resolve(new AdvertisedSocketAddress("emptyrecord.com", 0));
        this.logProvider.assertContainsMessageContaining("Failed to resolve srv records for '%s'");
    }

    @Test
    public void resolverRetriesUntilHostnamesAreFound() throws Exception {
        this.mockSrvRecordResolver.addRecords("_discovery._tcp.google.com", Arrays.asList(SrvRecordResolver.SrvRecord.parse((String)"1 1 80 1.2.3.4"), SrvRecordResolver.SrvRecord.parse((String)"1 1 8080 5.6.7.8")));
        SrvRecordResolver mockResolver = (SrvRecordResolver)Mockito.spy((Object)((Object)this.mockSrvRecordResolver));
        Mockito.when((Object)mockResolver.resolveSrvRecord(ArgumentMatchers.anyString())).thenReturn(Stream.empty()).thenReturn(Stream.empty()).thenCallRealMethod();
        SrvHostnameResolver resolver = new SrvHostnameResolver((LogProvider)this.logProvider, (LogProvider)this.userLogProvider, mockResolver, this.config, this.testRetryStrategy(2));
        Collection resolvedAddresses = resolver.resolve(new AdvertisedSocketAddress("_discovery._tcp.google.com", 0));
        ((SrvRecordResolver)Mockito.verify((Object)mockResolver, (VerificationMode)Mockito.times((int)3))).resolveSrvRecord("_discovery._tcp.google.com");
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("1.2.3.4") && address.getPort() == 80));
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("5.6.7.8") && address.getPort() == 8080));
    }

    private MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> testRetryStrategy(int numRetries) {
        return new MultiRetryStrategy(0L, (long)numRetries, (LogProvider)NullLogProvider.getInstance(), (LongConsumer)new MultiRetryStrategyTest.CountingSleeper());
    }
}

