/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Map;
import java.util.Optional;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddressParser;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.SafeLifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class SharedDiscoveryReadReplicaClient
extends SafeLifecycle
implements TopologyService {
    private final SharedDiscoveryService sharedDiscoveryService;
    private final ReadReplicaInfo addresses;
    private final MemberId memberId;
    private final Log log;
    private final String dbName;

    SharedDiscoveryReadReplicaClient(SharedDiscoveryService sharedDiscoveryService, Config config, MemberId memberId, LogProvider logProvider) {
        this.sharedDiscoveryService = sharedDiscoveryService;
        this.dbName = (String)config.get(CausalClusteringSettings.database);
        this.addresses = new ReadReplicaInfo(ClientConnectorAddresses.extractFromConfig((Config)config), (AdvertisedSocketAddress)SocketAddressParser.socketAddress((String)((AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address)).toString(), AdvertisedSocketAddress::new), this.dbName);
        this.memberId = memberId;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void init0() {
    }

    public void start0() {
        this.sharedDiscoveryService.registerReadReplica(this);
        this.log.info("Registered read replica member id: %s at %s", new Object[]{this.memberId, this.addresses});
    }

    public void stop0() {
        this.sharedDiscoveryService.unRegisterReadReplica(this);
    }

    public void shutdown0() {
    }

    public CoreTopology allCoreServers() {
        return this.sharedDiscoveryService.getCoreTopology(this.dbName, false);
    }

    public CoreTopology localCoreServers() {
        return this.allCoreServers().filterTopologyByDb(this.dbName);
    }

    public ReadReplicaTopology allReadReplicas() {
        return this.sharedDiscoveryService.getReadReplicaTopology();
    }

    public ReadReplicaTopology localReadReplicas() {
        return this.allReadReplicas().filterTopologyByDb(this.dbName);
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        return this.sharedDiscoveryService.getCoreTopology(this.dbName, false).find(upstream).map(info -> Optional.of(info.getCatchupServer())).orElseGet(() -> this.sharedDiscoveryService.getReadReplicaTopology().find(upstream).map(ReadReplicaInfo::getCatchupServer));
    }

    public String localDBName() {
        return this.dbName;
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.sharedDiscoveryService.getCoreRoles();
    }

    public MemberId myself() {
        return this.memberId;
    }

    public MemberId getMemberId() {
        return this.memberId;
    }

    public ReadReplicaInfo getReadReplicainfo() {
        return this.addresses;
    }
}

