/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Endpoint;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.core.MultiMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.HazelcastClient;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;

public class HazelcastClientTest {
    private MemberId myself = new MemberId(UUID.randomUUID());
    private static final java.util.function.Supplier<HashMap<String, String>> DEFAULT_SETTINGS = () -> {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(new BoltConnector((String)"bolt").type.name(), "BOLT");
        settings.put(new BoltConnector((String)"bolt").enabled.name(), "true");
        settings.put(new BoltConnector((String)"bolt").advertised_address.name(), "bolt:3001");
        settings.put(new BoltConnector((String)"http").type.name(), "HTTP");
        settings.put(new BoltConnector((String)"http").enabled.name(), "true");
        settings.put(new BoltConnector((String)"http").advertised_address.name(), "http:3001");
        return settings;
    };

    private Config config(String key, String value) {
        HashMap<String, String> defaults = DEFAULT_SETTINGS.get();
        defaults.put(key, value);
        return Config.defaults(defaults);
    }

    private Config config() {
        return Config.defaults((Map)DEFAULT_SETTINGS.get());
    }

    private HazelcastClient hzClient(OnDemandJobScheduler jobScheduler, Cluster cluster, Config config) {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        HazelcastClient client = new HazelcastClient(connector, (JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance(), config, this.myself);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastInstance.getSet(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastSet());
        Mockito.when((Object)hazelcastInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMultiMap());
        Mockito.when((Object)hazelcastInstance.getMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMap());
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance.getExecutorService(ArgumentMatchers.anyString())).thenReturn((Object)new StubExecutorService());
        return client;
    }

    private HazelcastClient startedClientWithMembers(Set<Member> members, Config config) throws Throwable {
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)cluster.getMembers()).thenReturn(members);
        HazelcastClient client = this.hzClient(jobScheduler, cluster, config);
        client.init();
        client.start();
        jobScheduler.runJob();
        return client;
    }

    @Test
    public void shouldReturnTopologyUsingHazelcastMembers() throws Throwable {
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        HazelcastClient client = this.startedClientWithMembers(members, this.config());
        CoreTopology topology = client.localCoreServers();
        Assert.assertEquals((long)members.size(), (long)topology.members().size());
    }

    @Test
    public void localAndAllTopologiesShouldMatchForSingleDBName() throws Throwable {
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        HazelcastClient client = this.startedClientWithMembers(members, this.config());
        String message = "Different local and global topologies reported despite single, default database name.";
        Assert.assertEquals((String)message, (Object)client.allCoreServers(), (Object)client.localCoreServers());
    }

    @Test
    public void localAndAllTopologiesShouldDifferForMultipleDBNames() throws Throwable {
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1, "foo"), this.makeMember(2, "bar")});
        HazelcastClient client = this.startedClientWithMembers(members, this.config(CausalClusteringSettings.database.name(), "foo"));
        String message = "Identical local and global topologies reported despite multiple, distinct database names.";
        Assert.assertNotEquals((String)message, (Object)client.allCoreServers(), (Object)client.localCoreServers());
        Assert.assertEquals((long)1L, (long)client.localCoreServers().members().size());
    }

    @Test
    public void allTopologyShouldContainAllMembers() throws Throwable {
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1, "foo"), this.makeMember(2, "bar")});
        HazelcastClient client = this.startedClientWithMembers(members, this.config(CausalClusteringSettings.database.name(), "foo"));
        String message = "Global topology should contain all Hazelcast Members despite different db names.";
        Assert.assertEquals((String)message, (long)members.size(), (long)client.allCoreServers().members().size());
    }

    @Test
    public void shouldNotReconnectWhileHazelcastRemainsAvailable() throws Throwable {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        HazelcastClient client = new HazelcastClient(connector, (JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.config(), this.myself);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        Mockito.when((Object)hazelcastInstance.getSet(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastSet());
        Mockito.when((Object)hazelcastInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMultiMap());
        Mockito.when((Object)hazelcastInstance.getExecutorService(ArgumentMatchers.anyString())).thenReturn((Object)new StubExecutorService());
        Mockito.when((Object)hazelcastInstance.getMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMap());
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        client.init();
        client.start();
        jobScheduler.runJob();
        for (int i = 0; i < 5; ++i) {
            CoreTopology topology = client.allCoreServers();
            Assert.assertEquals((long)members.size(), (long)topology.members().size());
        }
        ((HazelcastConnector)Mockito.verify((Object)connector, (VerificationMode)Mockito.times((int)1))).connectToHazelcast();
    }

    @Test
    public void shouldReturnEmptyTopologyIfUnableToConnectToHazelcast() throws Throwable {
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        LogProvider logProvider = (LogProvider)Mockito.mock(LogProvider.class);
        Log log = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)logProvider.getLog((Class)ArgumentMatchers.any(Class.class))).thenReturn((Object)log);
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenThrow(new Throwable[]{new IllegalStateException()});
        IAtomicReference iAtomicReference = (IAtomicReference)Mockito.mock(IAtomicReference.class);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(ArgumentMatchers.anyString())).thenReturn((Object)iAtomicReference);
        Mockito.when((Object)hazelcastInstance.getSet(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastSet());
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        HazelcastClient client = new HazelcastClient(connector, (JobScheduler)jobScheduler, logProvider, this.config(), this.myself);
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1), this.makeMember(2)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        client.init();
        client.start();
        jobScheduler.runJob();
        CoreTopology topology = client.allCoreServers();
        Assert.assertEquals((long)0L, (long)topology.members().size());
    }

    @Test
    public void shouldRegisterReadReplicaInTopology() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)endpoint.getUuid()).thenReturn((Object)"12345");
        Client client = (Client)Mockito.mock(Client.class);
        String clientId = "12345";
        Mockito.when((Object)client.getUuid()).thenReturn((Object)"12345");
        ClientService clientService = (ClientService)Mockito.mock(ClientService.class);
        Mockito.when((Object)clientService.getConnectedClients()).thenReturn((Object)Iterators.asSet((Object[])new Client[]{client}));
        HazelcastMap hazelcastMap = new HazelcastMap();
        HazelcastMultiMap hazelcastMultiMap = new HazelcastMultiMap();
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        IAtomicReference iAtomicReference = (IAtomicReference)Mockito.mock(IAtomicReference.class);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(ArgumentMatchers.anyString())).thenReturn((Object)iAtomicReference);
        Mockito.when((Object)hazelcastInstance.getMap(ArgumentMatchers.anyString())).thenReturn((Object)hazelcastMap);
        Mockito.when((Object)hazelcastInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)hazelcastMultiMap);
        Mockito.when((Object)hazelcastInstance.getLocalEndpoint()).thenReturn((Object)endpoint);
        Mockito.when((Object)hazelcastInstance.getExecutorService(ArgumentMatchers.anyString())).thenReturn((Object)new StubExecutorService());
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance.getClientService()).thenReturn((Object)clientService);
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        HazelcastClient hazelcastClient = new HazelcastClient(connector, (JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.config(), this.myself);
        hazelcastClient.init();
        hazelcastClient.start();
        jobScheduler.runJob();
        Assert.assertEquals((long)1L, (long)hazelcastMap.size());
    }

    @Test
    public void shouldRemoveReadReplicasOnGracefulShutdown() throws Throwable {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Set members = Iterators.asSet((Object[])new Member[]{this.makeMember(1)});
        Mockito.when((Object)cluster.getMembers()).thenReturn((Object)members);
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)endpoint.getUuid()).thenReturn((Object)"12345");
        Client client = (Client)Mockito.mock(Client.class);
        String clientId = "12345";
        Mockito.when((Object)client.getUuid()).thenReturn((Object)"12345");
        ClientService clientService = (ClientService)Mockito.mock(ClientService.class);
        Mockito.when((Object)clientService.getConnectedClients()).thenReturn((Object)Iterators.asSet((Object[])new Client[]{client}));
        HazelcastMap hazelcastMap = new HazelcastMap();
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        IAtomicReference iAtomicReference = (IAtomicReference)Mockito.mock(IAtomicReference.class);
        Mockito.when((Object)hazelcastInstance.getAtomicReference(ArgumentMatchers.anyString())).thenReturn((Object)iAtomicReference);
        Mockito.when((Object)hazelcastInstance.getMap(ArgumentMatchers.anyString())).thenReturn((Object)hazelcastMap);
        Mockito.when((Object)hazelcastInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMultiMap());
        Mockito.when((Object)hazelcastInstance.getLocalEndpoint()).thenReturn((Object)endpoint);
        Mockito.when((Object)hazelcastInstance.getExecutorService(ArgumentMatchers.anyString())).thenReturn((Object)new StubExecutorService());
        Mockito.when((Object)hazelcastInstance.getCluster()).thenReturn((Object)cluster);
        Mockito.when((Object)hazelcastInstance.getClientService()).thenReturn((Object)clientService);
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        HazelcastClient hazelcastClient = new HazelcastClient(connector, (JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.config(), this.myself);
        hazelcastClient.init();
        hazelcastClient.start();
        jobScheduler.runJob();
        hazelcastClient.stop();
        Assert.assertEquals((long)0L, (long)hazelcastMap.size());
    }

    @Test
    public void shouldSwallowNPEFromHazelcast() throws Throwable {
        Endpoint endpoint = (Endpoint)Mockito.mock(Endpoint.class);
        Mockito.when((Object)endpoint.getUuid()).thenReturn((Object)"12345");
        HazelcastInstance hazelcastInstance = (HazelcastInstance)Mockito.mock(HazelcastInstance.class);
        Mockito.when((Object)hazelcastInstance.getLocalEndpoint()).thenReturn((Object)endpoint);
        Mockito.when((Object)hazelcastInstance.getMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMap());
        Mockito.when((Object)hazelcastInstance.getMultiMap(ArgumentMatchers.anyString())).thenReturn((Object)new HazelcastMultiMap());
        ((HazelcastInstance)Mockito.doThrow((Throwable[])new Throwable[]{new NullPointerException("boom!!!")}).when((Object)hazelcastInstance)).shutdown();
        HazelcastConnector connector = (HazelcastConnector)Mockito.mock(HazelcastConnector.class);
        Mockito.when((Object)connector.connectToHazelcast()).thenReturn((Object)hazelcastInstance);
        OnDemandJobScheduler jobScheduler = new OnDemandJobScheduler();
        HazelcastClient hazelcastClient = new HazelcastClient(connector, (JobScheduler)jobScheduler, (LogProvider)NullLogProvider.getInstance(), this.config(), this.myself);
        hazelcastClient.init();
        hazelcastClient.start();
        jobScheduler.runJob();
        hazelcastClient.stop();
    }

    private Member makeMember(int id) {
        return this.makeMember(id, CausalClusteringSettings.database.getDefaultValue());
    }

    private Member makeMember(int id, String databaseName) {
        Member member = (Member)Mockito.mock(Member.class);
        Mockito.when((Object)member.getStringAttribute("member_uuid")).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)member.getStringAttribute("transaction_server")).thenReturn((Object)String.format("host%d:%d", id, 7000 + id));
        Mockito.when((Object)member.getStringAttribute("raft_server")).thenReturn((Object)String.format("host%d:%d", id, 6000 + id));
        Mockito.when((Object)member.getStringAttribute("client_connector_addresses")).thenReturn((Object)String.format("bolt://host%d:%d,http://host%d:%d", id, 5000 + id, id, 5000 + id));
        Mockito.when((Object)member.getStringAttribute("member_database_name")).thenReturn((Object)databaseName);
        return member;
    }

    private class StubExecutorService
    implements IExecutorService {
        private ExecutorService executor = Executors.newSingleThreadExecutor();

        private StubExecutorService() {
        }

        public void execute(Runnable command, MemberSelector memberSelector) {
        }

        public void executeOnKeyOwner(Runnable command, Object key) {
        }

        public void executeOnMember(Runnable command, Member member) {
        }

        public void executeOnMembers(Runnable command, Collection<Member> members) {
        }

        public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        }

        public void executeOnAllMembers(Runnable command) {
        }

        public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
            return null;
        }

        public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
            return null;
        }

        public <T> Future<T> submitToMember(Callable<T> task, Member member) {
            return null;
        }

        public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
            return null;
        }

        public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
            return null;
        }

        public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
            return null;
        }

        public <T> void submit(Runnable task, ExecutionCallback<T> callback) {
        }

        public <T> void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        }

        public <T> void submitToKeyOwner(Runnable task, Object key, ExecutionCallback<T> callback) {
        }

        public <T> void submitToMember(Runnable task, Member member, ExecutionCallback<T> callback) {
        }

        public void submitToMembers(Runnable task, Collection<Member> members, MultiExecutionCallback callback) {
        }

        public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        }

        public void submitToAllMembers(Runnable task, MultiExecutionCallback callback) {
        }

        public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        }

        public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        }

        public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        }

        public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        }

        public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        }

        public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        }

        public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        }

        public LocalExecutorStats getLocalExecutorStats() {
            return null;
        }

        public String getPartitionKey() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getServiceName() {
            return null;
        }

        public void destroy() {
        }

        public void shutdown() {
        }

        public List<Runnable> shutdownNow() {
            return null;
        }

        public boolean isShutdown() {
            return false;
        }

        public boolean isTerminated() {
            return false;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return false;
        }

        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        public Future<?> submit(Runnable task) {
            return null;
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            return null;
        }

        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            return null;
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
            return null;
        }

        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            return null;
        }

        public void execute(Runnable command) {
        }
    }

    private class HazelcastSet
    implements ISet<Object> {
        private Set<Object> delegate = new HashSet<Object>();

        HazelcastSet() {
        }

        public String getPartitionKey() {
            throw new IllegalStateException();
        }

        public String getName() {
            throw new IllegalStateException();
        }

        public String getServiceName() {
            throw new IllegalStateException();
        }

        public void destroy() {
            throw new IllegalStateException();
        }

        public String addItemListener(ItemListener<Object> listener, boolean includeValue) {
            throw new IllegalStateException();
        }

        public boolean removeItemListener(String registrationId) {
            throw new IllegalStateException();
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        public Iterator<Object> iterator() {
            return this.delegate.iterator();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        public boolean add(Object o) {
            return this.delegate.add(o);
        }

        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        public boolean addAll(Collection<?> c) {
            return this.delegate.addAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Spliterator<Object> spliterator() {
            return this.delegate.spliterator();
        }
    }

    private class HazelcastMultiMap
    implements MultiMap<Object, Object> {
        private Map<Object, Object> delegate = new HashMap<Object, Object>();

        private HazelcastMultiMap() {
        }

        public String getPartitionKey() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String getServiceName() {
            throw new UnsupportedOperationException();
        }

        public void destroy() {
            throw new UnsupportedOperationException();
        }

        public boolean put(Object key, Object value) {
            if (this.delegate.get(key) != null) {
                throw new UnsupportedOperationException("This is not a true multimap");
            }
            this.delegate.put(key, value);
            return true;
        }

        public Collection<Object> get(Object key) {
            return Iterators.asSet((Object[])new Object[]{this.delegate.get(key)});
        }

        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        public Collection<Object> remove(Object key) {
            return Iterators.asSet((Object[])new Object[]{this.delegate.remove(key)});
        }

        public Set<Object> localKeySet() {
            throw new UnsupportedOperationException();
        }

        public Set<Object> keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection<Object> values() {
            return this.delegate.values();
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        public boolean containsEntry(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.delegate.size();
        }

        public void clear() {
            this.delegate.clear();
        }

        public int valueCount(Object key) {
            throw new UnsupportedOperationException();
        }

        public String addLocalEntryListener(EntryListener<Object, Object> listener) {
            throw new UnsupportedOperationException();
        }

        public String addEntryListener(EntryListener<Object, Object> listener, boolean includeValue) {
            throw new UnsupportedOperationException();
        }

        public boolean removeEntryListener(String registrationId) {
            throw new UnsupportedOperationException();
        }

        public String addEntryListener(EntryListener<Object, Object> listener, Object key, boolean includeValue) {
            throw new UnsupportedOperationException();
        }

        public void lock(Object key) {
            throw new UnsupportedOperationException();
        }

        public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
            throw new UnsupportedOperationException();
        }

        public boolean isLocked(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeunit) {
            throw new UnsupportedOperationException();
        }

        public void unlock(Object key) {
            throw new UnsupportedOperationException();
        }

        public void forceUnlock(Object key) {
            throw new UnsupportedOperationException();
        }

        public LocalMultiMapStats getLocalMultiMapStats() {
            throw new UnsupportedOperationException();
        }

        public <SuppliedValue, Result> Result aggregate(Supplier<Object, Object, SuppliedValue> supplier, Aggregation<Object, SuppliedValue, Result> aggregation) {
            throw new UnsupportedOperationException();
        }

        public <SuppliedValue, Result> Result aggregate(Supplier<Object, Object, SuppliedValue> supplier, Aggregation<Object, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
            throw new UnsupportedOperationException();
        }
    }

    private class HazelcastMap
    implements IMap<Object, Object> {
        private HashMap delegate = new HashMap();

        private HazelcastMap() {
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Object get(Object key) {
            return this.delegate.get(key);
        }

        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        public Object put(Object key, Object value) {
            return this.delegate.put(key, value);
        }

        public void putAll(Map m) {
            this.delegate.putAll(m);
        }

        public Object remove(Object key) {
            return this.delegate.remove(key);
        }

        public void clear() {
            this.delegate.clear();
        }

        public ICompletableFuture<Object> getAsync(Object key) {
            return null;
        }

        public ICompletableFuture<Object> putAsync(Object key, Object value) {
            return null;
        }

        public ICompletableFuture<Object> putAsync(Object key, Object value, long ttl, TimeUnit timeunit) {
            return null;
        }

        public ICompletableFuture<Void> setAsync(Object o, Object o2) {
            return null;
        }

        public ICompletableFuture<Void> setAsync(Object o, Object o2, long l, TimeUnit timeUnit) {
            return null;
        }

        public ICompletableFuture<Object> removeAsync(Object key) {
            return null;
        }

        public boolean tryRemove(Object key, long timeout, TimeUnit timeunit) {
            return false;
        }

        public boolean tryPut(Object key, Object value, long timeout, TimeUnit timeunit) {
            return false;
        }

        public Object put(Object key, Object value, long ttl, TimeUnit timeunit) {
            return this.delegate.put(key, value);
        }

        public void putTransient(Object key, Object value, long ttl, TimeUnit timeunit) {
        }

        public boolean containsValue(Object value) {
            return this.delegate.containsValue(value);
        }

        public Set<Object> keySet() {
            return this.delegate.keySet();
        }

        public Collection<Object> values() {
            return this.delegate.values();
        }

        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.delegate.entrySet();
        }

        public Set<Object> keySet(Predicate predicate) {
            return null;
        }

        public Set<Map.Entry<Object, Object>> entrySet(Predicate predicate) {
            return null;
        }

        public Collection values(Predicate predicate) {
            return null;
        }

        public Set<Object> localKeySet() {
            return null;
        }

        public Set<Object> localKeySet(Predicate predicate) {
            return null;
        }

        public void addIndex(String attribute, boolean ordered) {
        }

        public LocalMapStats getLocalMapStats() {
            return null;
        }

        public Object executeOnKey(Object key, EntryProcessor entryProcessor) {
            return null;
        }

        public void submitToKey(Object key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        }

        public ICompletableFuture submitToKey(Object key, EntryProcessor entryProcessor) {
            return null;
        }

        public Map<Object, Object> executeOnEntries(EntryProcessor entryProcessor) {
            return null;
        }

        public Map<Object, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
            return null;
        }

        public Object aggregate(Supplier supplier, Aggregation aggregation, JobTracker jobTracker) {
            return null;
        }

        public Object aggregate(Supplier supplier, Aggregation aggregation) {
            return null;
        }

        public Map<Object, Object> executeOnKeys(Set keys, EntryProcessor entryProcessor) {
            return null;
        }

        public Object getOrDefault(Object key, Object defaultValue) {
            return this.delegate.getOrDefault(key, defaultValue);
        }

        public Object putIfAbsent(Object key, Object value) {
            return this.delegate.putIfAbsent(key, value);
        }

        public Object putIfAbsent(Object key, Object value, long ttl, TimeUnit timeunit) {
            return null;
        }

        public boolean remove(Object key, Object value) {
            return this.delegate.remove(key, value);
        }

        public void delete(Object key) {
        }

        public void flush() {
        }

        public void loadAll(boolean replaceExistingValues) {
        }

        public void loadAll(Set keys, boolean replaceExistingValues) {
        }

        public Map getAll(Set keys) {
            return null;
        }

        public boolean replace(Object key, Object oldValue, Object newValue) {
            return this.delegate.replace(key, oldValue, newValue);
        }

        public Object replace(Object key, Object value) {
            return this.delegate.replace(key, value);
        }

        public void set(Object key, Object value) {
        }

        public void set(Object key, Object value, long ttl, TimeUnit timeunit) {
        }

        public void lock(Object key) {
        }

        public void lock(Object key, long leaseTime, TimeUnit timeUnit) {
        }

        public boolean isLocked(Object key) {
            return false;
        }

        public boolean tryLock(Object key) {
            return false;
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit) {
            return false;
        }

        public boolean tryLock(Object key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseTimeunit) {
            return false;
        }

        public void unlock(Object key) {
        }

        public void forceUnlock(Object key) {
        }

        public String addLocalEntryListener(MapListener listener) {
            return null;
        }

        public String addLocalEntryListener(EntryListener listener) {
            return null;
        }

        public String addLocalEntryListener(MapListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addLocalEntryListener(EntryListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addLocalEntryListener(MapListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public String addLocalEntryListener(EntryListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public String addInterceptor(MapInterceptor interceptor) {
            return null;
        }

        public void removeInterceptor(String id) {
        }

        public String addEntryListener(MapListener listener, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, boolean includeValue) {
            return null;
        }

        public boolean removeEntryListener(String id) {
            return false;
        }

        public String addPartitionLostListener(MapPartitionLostListener listener) {
            return null;
        }

        public boolean removePartitionLostListener(String id) {
            return false;
        }

        public String addEntryListener(MapListener listener, Object key, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, Object key, boolean includeValue) {
            return null;
        }

        public String addEntryListener(MapListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, Predicate predicate, boolean includeValue) {
            return null;
        }

        public String addEntryListener(MapListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public String addEntryListener(EntryListener listener, Predicate predicate, Object key, boolean includeValue) {
            return null;
        }

        public EntryView getEntryView(Object key) {
            return null;
        }

        public boolean evict(Object key) {
            return false;
        }

        public void evictAll() {
        }

        public Object computeIfAbsent(Object key, Function mappingFunction) {
            return this.delegate.computeIfAbsent(key, mappingFunction);
        }

        public Object computeIfPresent(Object key, BiFunction remappingFunction) {
            return this.delegate.computeIfPresent(key, remappingFunction);
        }

        public Object compute(Object key, BiFunction remappingFunction) {
            return this.delegate.compute(key, remappingFunction);
        }

        public Object merge(Object key, Object value, BiFunction remappingFunction) {
            return this.delegate.merge(key, value, remappingFunction);
        }

        public void forEach(BiConsumer action) {
            this.delegate.forEach(action);
        }

        public void replaceAll(BiFunction function) {
            this.delegate.replaceAll(function);
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        public String getPartitionKey() {
            return null;
        }

        public String getName() {
            return "name";
        }

        public String getServiceName() {
            return "serviceName";
        }

        public void destroy() {
        }
    }
}

