/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.ports.allocation.PortAuthority;

public class EnterpriseCluster
extends Cluster<DiscoveryServiceFactory> {
    public EnterpriseCluster(File parentDir, int noOfCoreMembers, int noOfReadReplicas, DiscoveryServiceFactory discoveryServiceFactory, Map<String, String> coreParams, Map<String, IntFunction<String>> instanceCoreParams, Map<String, String> readReplicaParams, Map<String, IntFunction<String>> instanceReadReplicaParams, String recordFormat, IpFamily ipFamily, boolean useWildcard) {
        super(parentDir, noOfCoreMembers, noOfReadReplicas, discoveryServiceFactory, coreParams, instanceCoreParams, readReplicaParams, instanceReadReplicaParams, recordFormat, ipFamily, useWildcard);
    }

    public EnterpriseCluster(File parentDir, int noOfCoreMembers, int noOfReadReplicas, DiscoveryServiceFactory discoveryServiceFactory, Map<String, String> coreParams, Map<String, IntFunction<String>> instanceCoreParams, Map<String, String> readReplicaParams, Map<String, IntFunction<String>> instanceReadReplicaParams, String recordFormat, IpFamily ipFamily, boolean useWildcard, Set<String> dbNames) {
        super(parentDir, noOfCoreMembers, noOfReadReplicas, discoveryServiceFactory, coreParams, instanceCoreParams, readReplicaParams, instanceReadReplicaParams, recordFormat, ipFamily, useWildcard, dbNames);
    }

    @Override
    protected CoreClusterMember createCoreClusterMember(int serverId, int discoveryPort, int clusterSize, List<AdvertisedSocketAddress> initialHosts, String recordFormat, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams) {
        int txPort = PortAuthority.allocatePort();
        int raftPort = PortAuthority.allocatePort();
        int boltPort = PortAuthority.allocatePort();
        int httpPort = PortAuthority.allocatePort();
        int backupPort = PortAuthority.allocatePort();
        return new CoreClusterMember(serverId, discoveryPort, txPort, raftPort, boltPort, httpPort, backupPort, clusterSize, initialHosts, this.discoveryServiceFactory, recordFormat, this.parentDir, extraParams, instanceExtraParams, this.listenAddress, this.advertisedAddress);
    }

    @Override
    protected ReadReplica createReadReplica(int serverId, List<AdvertisedSocketAddress> initialHosts, Map<String, String> extraParams, Map<String, IntFunction<String>> instanceExtraParams, String recordFormat, Monitors monitors) {
        int boltPort = PortAuthority.allocatePort();
        int httpPort = PortAuthority.allocatePort();
        int txPort = PortAuthority.allocatePort();
        int backupPort = PortAuthority.allocatePort();
        int discoveryPort = PortAuthority.allocatePort();
        return new ReadReplica(this.parentDir, serverId, boltPort, httpPort, txPort, backupPort, discoveryPort, this.discoveryServiceFactory, initialHosts, extraParams, instanceExtraParams, recordFormat, monitors, this.advertisedAddress, this.listenAddress);
    }
}

