/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.LongConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.DnsHostnameResolver;
import org.neo4j.causalclustering.discovery.DomainNameResolver;
import org.neo4j.causalclustering.discovery.MapDomainNameResolver;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.causalclustering.discovery.MultiRetryStrategyTest;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class DnsHostnameResolverTest {
    private final MapDomainNameResolver mockDomainNameResolver = new MapDomainNameResolver(new HashMap());
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    private final AssertableLogProvider userLogProvider = new AssertableLogProvider();
    private final Config config = Config.defaults((Setting)CausalClusteringSettings.minimum_core_cluster_size_at_formation, (String)"2");
    private final DnsHostnameResolver resolver = new DnsHostnameResolver((LogProvider)this.logProvider, (LogProvider)this.userLogProvider, (DomainNameResolver)this.mockDomainNameResolver, this.config, this.testRetryStrategy(1));

    @Test
    public void hostnamesAreResolvedByTheResolver() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        Collection resolvedAddresses = this.resolver.resolve(new AdvertisedSocketAddress("google.com", 80));
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("1.2.3.4")));
        Assert.assertTrue((boolean)resolvedAddresses.removeIf(address -> address.getHostname().equals("5.6.7.8")));
    }

    @Test
    public void resolvedHostnamesUseTheSamePort() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        ArrayList resolvedAddresses = new ArrayList(this.resolver.resolve(new AdvertisedSocketAddress("google.com", 1234)));
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertEquals((long)1234L, (long)((AdvertisedSocketAddress)resolvedAddresses.get(0)).getPort());
        Assert.assertEquals((long)1234L, (long)((AdvertisedSocketAddress)resolvedAddresses.get(1)).getPort());
    }

    @Test
    public void resolutionDetailsAreLoggedToUserLogs() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        this.resolver.resolve(new AdvertisedSocketAddress("google.com", 1234));
        this.userLogProvider.assertContainsMessageContaining("Resolved initial host '%s' to %s");
    }

    @Test
    public void unknownHostExceptionsAreLoggedAsErrors() {
        this.resolver.resolve(new AdvertisedSocketAddress("google.com", 1234));
        this.logProvider.assertContainsMessageContaining("Failed to resolve host '%s'");
    }

    @Test
    public void resolverRetriesUntilHostnamesAreFound() {
        this.mockDomainNameResolver.setHostnameAddresses("google.com", Arrays.asList("1.2.3.4", "5.6.7.8"));
        DomainNameResolver mockResolver = (DomainNameResolver)Mockito.spy((Object)this.mockDomainNameResolver);
        Mockito.when((Object)mockResolver.resolveDomainName(ArgumentMatchers.anyString())).thenReturn((Object)new InetAddress[0]).thenReturn((Object)new InetAddress[0]).thenCallRealMethod();
        DnsHostnameResolver resolver = new DnsHostnameResolver((LogProvider)this.logProvider, (LogProvider)this.userLogProvider, mockResolver, this.config, this.testRetryStrategy(2));
        ArrayList resolvedAddresses = new ArrayList(resolver.resolve(new AdvertisedSocketAddress("google.com", 1234)));
        ((DomainNameResolver)Mockito.verify((Object)mockResolver, (VerificationMode)Mockito.times((int)3))).resolveDomainName("google.com");
        Assert.assertEquals((long)2L, (long)resolvedAddresses.size());
        Assert.assertEquals((long)1234L, (long)((AdvertisedSocketAddress)resolvedAddresses.get(0)).getPort());
        Assert.assertEquals((long)1234L, (long)((AdvertisedSocketAddress)resolvedAddresses.get(1)).getPort());
    }

    private MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> testRetryStrategy(int numRetries) {
        return new MultiRetryStrategy(0L, (long)numRetries, (LogProvider)NullLogProvider.getInstance(), (LongConsumer)new MultiRetryStrategyTest.CountingSleeper());
    }
}

