/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.diagnostics;

import java.util.UUID;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.causalclustering.diagnostics.CoreMonitor;
import org.neo4j.causalclustering.identity.ClusterBinder;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.SimpleLogService;

public class CoreMonitorTest {
    @Test
    public void shouldNotDuplicateToAnyLog() {
        AssertableLogProvider user = new AssertableLogProvider();
        AssertableLogProvider debug = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)user, (LogProvider)debug);
        Monitors monitors = new Monitors();
        CoreMonitor.register((LogProvider)logService.getInternalLogProvider(), (LogProvider)logService.getUserLogProvider(), (Monitors)monitors);
        ClusterBinder.Monitor monitor = (ClusterBinder.Monitor)monitors.newMonitor(ClusterBinder.Monitor.class, new String[0]);
        ClusterId clusterId = new ClusterId(UUID.randomUUID());
        monitor.boundToCluster(clusterId);
        user.assertContainsExactlyOneMessageMatching(Matchers.equalToIgnoringCase((String)("Bound to cluster with id " + clusterId.uuid())));
        debug.assertContainsExactlyOneMessageMatching(Matchers.equalToIgnoringCase((String)("Bound to cluster with id " + clusterId.uuid())));
    }
}

