/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.storage;

import java.io.File;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.storage.SimpleFileStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class SimpleStorageTest {
    @Rule
    public EphemeralFileSystemRule fsa = new EphemeralFileSystemRule();

    @Test
    public void shouldWriteAndReadState() throws Exception {
        SimpleFileStorage storage = new SimpleFileStorage(this.fsa.get(), new File("state-dir"), "member-id-a", (ChannelMarshal)new MemberId.Marshal(), (LogProvider)NullLogProvider.getInstance());
        MemberId idA = new MemberId(UUID.randomUUID());
        storage.writeState((Object)idA);
        MemberId idB = (MemberId)storage.readState();
        Assert.assertEquals((Object)idA.getUuid(), (Object)idB.getUuid());
        Assert.assertEquals((Object)idA, (Object)idB);
    }
}

