/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationReplicatedTransaction;
import org.neo4j.causalclustering.helpers.Buffers;
import org.neo4j.causalclustering.messaging.NetworkWritableChannel;
import org.neo4j.causalclustering.messaging.marshalling.OutputStreamWritableChannel;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.WritableChannel;

public class TransactionRepresentationReplicatedTransactionTest {
    @Rule
    public final Buffers buffers = new Buffers();

    @Test
    public void shouldMarshalToSameByteIfByteBufBackedOrNot() throws IOException {
        PhysicalTransactionRepresentation expectedTx = new PhysicalTransactionRepresentation(Collections.singleton(new Command.NodeCommand(new NodeRecord(1L), new NodeRecord(2L))));
        expectedTx.setHeader(new byte[0], 1, 2, 3L, 4L, 5L, 6);
        TransactionRepresentationReplicatedTransaction replicatedTransaction = ReplicatedTransaction.from((TransactionRepresentation)expectedTx);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteBuf buffer = this.buffers.buffer();
        OutputStreamWritableChannel outputStreamWritableChannel = new OutputStreamWritableChannel((OutputStream)stream);
        NetworkWritableChannel networkWritableChannel = new NetworkWritableChannel(buffer);
        replicatedTransaction.marshal((WritableChannel)outputStreamWritableChannel);
        replicatedTransaction.marshal((WritableChannel)networkWritableChannel);
        byte[] bufferArray = Arrays.copyOf(buffer.array(), buffer.writerIndex());
        Assertions.assertArrayEquals((byte[])bufferArray, (byte[])stream.toByteArray());
    }
}

