/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionStateMachine;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationReplicatedTransaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.FakeCommitment;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTransactionStateMachineTest {
    private final NullLogProvider logProvider = NullLogProvider.getInstance();
    private final CommandIndexTracker commandIndexTracker = new CommandIndexTracker();
    private final int batchSize = 16;

    @Test
    public void shouldCommitTransaction() throws Exception {
        int lockSessionId = 23;
        TransactionRepresentationReplicatedTransaction tx = ReplicatedTransaction.from((TransactionRepresentation)this.physicalTx(lockSessionId));
        TransactionCommitProcess localCommitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        PageCursorTracer cursorTracer = (PageCursorTracer)Mockito.mock(PageCursorTracer.class);
        ReplicatedTransactionStateMachine stateMachine = new ReplicatedTransactionStateMachine(this.commandIndexTracker, this.lockState(lockSessionId), 16, (LogProvider)this.logProvider, () -> cursorTracer, EmptyVersionContextSupplier.EMPTY);
        stateMachine.installCommitProcess(localCommitProcess, -1L);
        stateMachine.applyCommand((ReplicatedTransaction)tx, 0L, r -> {});
        stateMachine.ensuredApplied();
        ((TransactionCommitProcess)Mockito.verify((Object)localCommitProcess, (VerificationMode)Mockito.times((int)1))).commit((TransactionToApply)ArgumentMatchers.any(TransactionToApply.class), (CommitEvent)ArgumentMatchers.any(CommitEvent.class), (TransactionApplicationMode)ArgumentMatchers.any(TransactionApplicationMode.class));
        ((PageCursorTracer)Mockito.verify((Object)cursorTracer, (VerificationMode)Mockito.times((int)1))).reportEvents();
    }

    @Test
    public void shouldFailFutureForTransactionCommittedUnderWrongLockSession() {
        int txLockSessionId = 23;
        int currentLockSessionId = 24;
        TransactionRepresentationReplicatedTransaction tx = ReplicatedTransaction.from((TransactionRepresentation)this.physicalTx(txLockSessionId));
        TransactionCommitProcess localCommitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        ReplicatedTransactionStateMachine stateMachine = new ReplicatedTransactionStateMachine(this.commandIndexTracker, this.lockState(currentLockSessionId), 16, (LogProvider)this.logProvider, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
        stateMachine.installCommitProcess(localCommitProcess, -1L);
        AtomicBoolean called = new AtomicBoolean();
        stateMachine.applyCommand((ReplicatedTransaction)tx, 0L, result -> {
            called.set(true);
            try {
                result.consume();
                Assert.fail((String)"should have thrown");
            }
            catch (TransactionFailureException tfe) {
                Assert.assertEquals((Object)Status.Transaction.LockSessionExpired, (Object)tfe.status());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        stateMachine.ensuredApplied();
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void shouldAcceptTransactionCommittedWithNoLockManager() throws Exception {
        int txLockSessionId = -1;
        int currentLockSessionId = 24;
        long txId = 42L;
        TransactionRepresentationReplicatedTransaction tx = ReplicatedTransaction.from((TransactionRepresentation)this.physicalTx(txLockSessionId));
        TransactionCommitProcess localCommitProcess = this.createFakeTransactionCommitProcess(txId);
        ReplicatedTransactionStateMachine stateMachine = new ReplicatedTransactionStateMachine(this.commandIndexTracker, this.lockState(currentLockSessionId), 16, (LogProvider)this.logProvider, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
        stateMachine.installCommitProcess(localCommitProcess, -1L);
        AtomicBoolean called = new AtomicBoolean();
        stateMachine.applyCommand((ReplicatedTransaction)tx, 0L, result -> {
            called.set(true);
            try {
                Assert.assertEquals((long)txId, (long)((Long)result.consume()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        stateMachine.ensuredApplied();
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void raftIndexIsRecorded() throws TransactionFailureException {
        int txLockSessionId = -1;
        long anyTransactionId = 1234L;
        long lastCommittedIndex = 1357L;
        long updatedCommandIndex = 2468L;
        ReplicatedTransactionStateMachine stateMachine = new ReplicatedTransactionStateMachine(this.commandIndexTracker, this.lockState(txLockSessionId), 16, (LogProvider)this.logProvider, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
        TransactionRepresentationReplicatedTransaction replicatedTransaction = ReplicatedTransaction.from((TransactionRepresentation)this.physicalTx(txLockSessionId));
        TransactionCommitProcess localCommitProcess = this.createFakeTransactionCommitProcess(anyTransactionId);
        stateMachine.installCommitProcess(localCommitProcess, lastCommittedIndex);
        Assert.assertEquals((long)lastCommittedIndex, (long)this.commandIndexTracker.getAppliedCommandIndex());
        stateMachine.applyCommand((ReplicatedTransaction)replicatedTransaction, updatedCommandIndex, result -> {});
        stateMachine.ensuredApplied();
        Assert.assertEquals((long)updatedCommandIndex, (long)this.commandIndexTracker.getAppliedCommandIndex());
    }

    private TransactionCommitProcess createFakeTransactionCommitProcess(long txId) throws TransactionFailureException {
        TransactionCommitProcess localCommitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
        Mockito.when((Object)localCommitProcess.commit((TransactionToApply)ArgumentMatchers.any(TransactionToApply.class), (CommitEvent)ArgumentMatchers.any(CommitEvent.class), (TransactionApplicationMode)ArgumentMatchers.any(TransactionApplicationMode.class))).thenAnswer(invocation -> {
            TransactionToApply txToApply = (TransactionToApply)invocation.getArgument(0);
            txToApply.commitment((Commitment)new FakeCommitment(txId, (TransactionIdStore)Mockito.mock(TransactionIdStore.class)), txId);
            txToApply.commitment().publishAsCommitted();
            txToApply.commitment().publishAsClosed();
            txToApply.close();
            return txId;
        });
        return localCommitProcess;
    }

    private PhysicalTransactionRepresentation physicalTx(int lockSessionId) {
        PhysicalTransactionRepresentation physicalTx = (PhysicalTransactionRepresentation)Mockito.mock(PhysicalTransactionRepresentation.class);
        Mockito.when((Object)physicalTx.getLockSessionId()).thenReturn((Object)lockSessionId);
        return physicalTx;
    }

    private ReplicatedLockTokenStateMachine lockState(int lockSessionId) {
        ReplicatedLockTokenStateMachine lockState = (ReplicatedLockTokenStateMachine)Mockito.mock(ReplicatedLockTokenStateMachine.class);
        Mockito.when((Object)lockState.currentToken()).thenReturn((Object)new ReplicatedLockTokenRequest(null, lockSessionId));
        return lockState;
    }
}

