/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.impl.store.id.IdType;

public class ReplicatedIdAllocationStateMachineTest {
    private MemberId me = new MemberId(UUID.randomUUID());
    private IdType someType = IdType.NODE;
    private IdType someOtherType = IdType.RELATIONSHIP;

    @Test
    public void shouldNotHaveAnyIdsInitially() {
        ReplicatedIdAllocationStateMachine stateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
        Assert.assertEquals((long)0L, (long)stateMachine.firstUnallocated(this.someType));
    }

    @Test
    public void shouldUpdateStateOnlyForTypeRequested() {
        ReplicatedIdAllocationStateMachine stateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
        ReplicatedIdAllocationRequest idAllocationRequest = new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 1024);
        stateMachine.applyCommand(idAllocationRequest, 0L, r -> {});
        Assert.assertEquals((long)1024L, (long)stateMachine.firstUnallocated(this.someType));
        Assert.assertEquals((long)0L, (long)stateMachine.firstUnallocated(this.someOtherType));
    }

    @Test
    public void severalDistinctRequestsShouldIncrementallyUpdate() {
        ReplicatedIdAllocationStateMachine stateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
        long index = 0L;
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 1024), index++, r -> {});
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 1024L, 1024), index++, r -> {});
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 2048L, 1024), index, r -> {});
        Assert.assertEquals((long)3072L, (long)stateMachine.firstUnallocated(this.someType));
    }

    @Test
    public void severalEqualRequestsShouldOnlyUpdateOnce() {
        ReplicatedIdAllocationStateMachine stateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 1024), 0L, r -> {});
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 1024), 0L, r -> {});
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 1024), 0L, r -> {});
        Assert.assertEquals((long)1024L, (long)stateMachine.firstUnallocated(this.someType));
    }

    @Test
    public void outOfOrderRequestShouldBeIgnored() {
        ReplicatedIdAllocationStateMachine stateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 1024), 0L, r -> {});
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 2048L, 1024), 0L, r -> {});
        Assert.assertEquals((long)1024L, (long)stateMachine.firstUnallocated(this.someType));
    }

    @Test
    public void shouldIgnoreNotContiguousRequestAndAlreadySeenIndex() {
        ReplicatedIdAllocationStateMachine stateMachine = new ReplicatedIdAllocationStateMachine((StateStorage)new InMemoryStateStorage((Object)new IdAllocationState()));
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 0L, 10), 0L, r -> {});
        Assert.assertEquals((long)10L, (long)stateMachine.firstUnallocated(this.someType));
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 20L, 10), 1L, r -> {});
        Assert.assertEquals((long)10L, (long)stateMachine.firstUnallocated(this.someType));
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 10L, 10), 2L, r -> {});
        Assert.assertEquals((long)20L, (long)stateMachine.firstUnallocated(this.someType));
        stateMachine.applyCommand(new ReplicatedIdAllocationRequest(this.me, this.someType, 20L, 10), 1L, r -> {});
        Assert.assertEquals((long)20L, (long)stateMachine.firstUnallocated(this.someType));
    }
}

