/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.causalclustering.core.replication.LeaderProvider;
import org.neo4j.causalclustering.identity.MemberId;

public class LeaderProviderTest {
    private static final MemberId MEMBER_ID = new MemberId(UUID.randomUUID());
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final LeaderProvider leaderProvider = new LeaderProvider();

    @Before
    public void before() {
        this.leaderProvider.setLeader(null);
    }

    @Test
    public void shouldGiveCurrentLeaderIfAvailable() throws InterruptedException {
        this.leaderProvider.setLeader(MEMBER_ID);
        Assert.assertEquals((Object)this.leaderProvider.currentLeader(), (Object)MEMBER_ID);
        Assert.assertEquals((Object)this.leaderProvider.awaitLeader(), (Object)MEMBER_ID);
    }

    @Test
    public void shouldWaitForNonNullValue() throws InterruptedException, ExecutionException, TimeoutException {
        int threads = 3;
        Assert.assertNull((Object)this.leaderProvider.currentLeader());
        CompletionStage<ArrayList<Object>> futures = CompletableFuture.completedFuture(new ArrayList());
        for (int i = 0; i < threads; ++i) {
            CompletableFuture<MemberId> future = CompletableFuture.supplyAsync(this.getCurrentLeader(), this.executorService);
            futures = futures.thenCombine(future, (completableFutures, memberId) -> {
                completableFutures.add(memberId);
                return completableFutures;
            });
        }
        Thread.sleep(100L);
        Assert.assertFalse((boolean)futures.isDone());
        this.leaderProvider.setLeader(MEMBER_ID);
        ArrayList memberIds = futures.get(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)memberIds.stream().allMatch(memberId -> memberId.equals((Object)MEMBER_ID)));
    }

    private Supplier<MemberId> getCurrentLeader() {
        return () -> {
            try {
                return this.leaderProvider.awaitLeader();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted");
            }
        };
    }
}

