/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembership;
import org.neo4j.causalclustering.core.consensus.outcome.AppendLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerState;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class RaftStateTest {
    @Test
    public void shouldUpdateCacheState() throws Exception {
        ConsecutiveInFlightCache cache = new ConsecutiveInFlightCache();
        RaftState raftState = new RaftState(RaftTestMember.member(0), (StateStorage)new InMemoryStateStorage((Object)new TermState()), (RaftMembership)new FakeMembership(), (RaftLog)new InMemoryRaftLog(), (StateStorage)new InMemoryStateStorage((Object)new VoteState()), (InFlightCache)cache, (LogProvider)NullLogProvider.getInstance(), false, false);
        LinkedList<RaftLogCommand> logCommands = new LinkedList<RaftLogCommand>(){
            {
                this.add(new AppendLogEntry(1L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0))));
                this.add(new AppendLogEntry(2L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1))));
                this.add(new AppendLogEntry(3L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(2))));
                this.add(new AppendLogEntry(4L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(4))));
                this.add(new TruncateLogCommand(3L));
                this.add(new AppendLogEntry(3L, new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(5))));
            }
        };
        Outcome raftTestMemberOutcome = new Outcome(Role.CANDIDATE, 0L, null, -1L, null, Collections.emptySet(), Collections.emptySet(), -1L, this.initialFollowerStates(), true, (Collection)logCommands, this.emptyOutgoingMessages(), Collections.emptySet(), -1L, Collections.emptySet(), false);
        raftState.update(raftTestMemberOutcome);
        Assert.assertNotNull((Object)cache.get(1L));
        Assert.assertNotNull((Object)cache.get(2L));
        Assert.assertNotNull((Object)cache.get(3L));
        Assert.assertEquals((Object)ReplicatedInteger.valueOf(5), (Object)cache.get(3L).content());
        Assert.assertNull((Object)cache.get(4L));
    }

    @Test
    public void shouldRemoveFollowerStateAfterBecomingLeader() throws Exception {
        RaftState raftState = new RaftState(RaftTestMember.member(0), (StateStorage)new InMemoryStateStorage((Object)new TermState()), (RaftMembership)new FakeMembership(), (RaftLog)new InMemoryRaftLog(), (StateStorage)new InMemoryStateStorage((Object)new VoteState()), (InFlightCache)new ConsecutiveInFlightCache(), (LogProvider)NullLogProvider.getInstance(), false, false);
        raftState.update(new Outcome(Role.CANDIDATE, 1L, null, -1L, null, Collections.emptySet(), Collections.emptySet(), -1L, this.initialFollowerStates(), true, this.emptyLogCommands(), this.emptyOutgoingMessages(), Collections.emptySet(), -1L, Collections.emptySet(), false));
        raftState.update(new Outcome(Role.CANDIDATE, 1L, null, -1L, null, Collections.emptySet(), Collections.emptySet(), -1L, new FollowerStates(), true, this.emptyLogCommands(), this.emptyOutgoingMessages(), Collections.emptySet(), -1L, Collections.emptySet(), false));
        Assert.assertEquals((long)0L, (long)raftState.followerStates().size());
    }

    private Collection<RaftMessages.Directed> emptyOutgoingMessages() {
        return new ArrayList<RaftMessages.Directed>();
    }

    private FollowerStates<MemberId> initialFollowerStates() {
        return new FollowerStates(new FollowerStates(), (Object)RaftTestMember.member(1), new FollowerState());
    }

    private Collection<RaftLogCommand> emptyLogCommands() {
        return Collections.emptyList();
    }

    private class FakeMembership
    implements RaftMembership {
        private FakeMembership() {
        }

        public Set<MemberId> votingMembers() {
            return Collections.emptySet();
        }

        public Set<MemberId> replicationMembers() {
            return Collections.emptySet();
        }

        public void registerListener(RaftMembership.Listener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

