/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.BoundedNetworkWritableChannel;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class MemberIdMarshalTest {
    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        MemberId.Marshal marshal = new MemberId.Marshal();
        MemberId member = new MemberId(UUID.randomUUID());
        ByteBuf buffer = Unpooled.buffer((int)1000);
        marshal.marshal(member, (WritableChannel)new BoundedNetworkWritableChannel(buffer));
        MemberId recovered = (MemberId)marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer));
        Assert.assertEquals((Object)member, (Object)recovered);
    }

    @Test
    public void shouldThrowExceptionForHalfWrittenInstance() throws Exception {
        MemberId.Marshal marshal = new MemberId.Marshal();
        MemberId aRealMember = new MemberId(UUID.randomUUID());
        ByteBuf buffer = Unpooled.buffer((int)1000);
        marshal.marshal(aRealMember, (WritableChannel)new BoundedNetworkWritableChannel(buffer));
        ByteBuf bufferWithMissingBytes = buffer.copy(0, buffer.writerIndex() - 5);
        try {
            marshal.unmarshal((ReadableChannel)new NetworkReadableClosableChannelNetty4(bufferWithMissingBytes));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
    }
}

