/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogCursorIT {
    private final LifeSupport life = new LifeSupport();
    private FileSystemAbstraction fileSystem;

    @After
    public void tearDown() throws Throwable {
        this.life.stop();
        this.life.shutdown();
        this.fileSystem.close();
    }

    private SegmentedRaftLog createRaftLog(long rotateAtSize, String pruneStrategy) {
        if (this.fileSystem == null) {
            this.fileSystem = new EphemeralFileSystemAbstraction();
        }
        File directory = new File("raft-log");
        this.fileSystem.mkdir(directory);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory(pruneStrategy, (LogProvider)logProvider).newInstance();
        SegmentedRaftLog newRaftLog = new SegmentedRaftLog(this.fileSystem, directory, rotateAtSize, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, 8, Clocks.systemClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy);
        this.life.add((Lifecycle)newRaftLog);
        this.life.init();
        this.life.start();
        return newRaftLog;
    }

    private SegmentedRaftLog createRaftLog(long rotateAtSize) {
        return this.createRaftLog(rotateAtSize, CausalClusteringSettings.raft_log_pruning_strategy.getDefaultValue());
    }

    @Test
    public void shouldReturnFalseOnCursorForEntryThatDoesntExist() throws Exception {
        boolean next;
        SegmentedRaftLog segmentedRaftLog = this.createRaftLog(1L);
        segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        long lastIndex = segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(3))});
        try (RaftLogCursor entryCursor = segmentedRaftLog.getEntryCursor(lastIndex + 1L);){
            next = entryCursor.next();
        }
        Assert.assertFalse((boolean)next);
    }

    @Test
    public void shouldReturnTrueOnEntryThatExists() throws Exception {
        boolean next;
        SegmentedRaftLog segmentedRaftLog = this.createRaftLog(1L);
        segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        long lastIndex = segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(3))});
        try (RaftLogCursor entryCursor = segmentedRaftLog.getEntryCursor(lastIndex);){
            next = entryCursor.next();
        }
        Assert.assertTrue((boolean)next);
    }

    @Test
    public void shouldReturnFalseOnCursorForEntryThatWasPruned() throws Exception {
        SegmentedRaftLog segmentedRaftLog = this.createRaftLog(1L, "keep_none");
        long firstIndex = segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2))});
        long lastIndex = segmentedRaftLog.append(new RaftLogEntry[]{new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(3))});
        segmentedRaftLog.prune(firstIndex);
        RaftLogCursor entryCursor = segmentedRaftLog.getEntryCursor(firstIndex);
        boolean next = entryCursor.next();
        Assert.assertFalse((boolean)next);
    }
}

