/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.debug;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.time.Clocks;

public class ReplayRaftLog {
    private ReplayRaftLog() {
    }

    public static void main(String[] args) throws IOException {
        Args arg = Args.parse((String[])args);
        String from = arg.get("from");
        System.out.println("From is " + from);
        String to = arg.get("to");
        System.out.println("to is " + to);
        File logDirectory = new File(from);
        System.out.println("logDirectory = " + logDirectory);
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[0]));
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            NullLogProvider logProvider = NullLogProvider.getInstance();
            CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory((String)config.get(CausalClusteringSettings.raft_log_pruning_strategy), (LogProvider)logProvider).newInstance();
            SegmentedRaftLog log = new SegmentedRaftLog((FileSystemAbstraction)fileSystem, logDirectory, ((Long)config.get(CausalClusteringSettings.raft_log_rotation_size)).longValue(), (ChannelMarshal)CoreReplicatedContentMarshal.marshaller(), (LogProvider)logProvider, ((Integer)config.get(CausalClusteringSettings.raft_log_reader_pool_size)).intValue(), Clocks.systemClock(), (JobScheduler)new ThreadPoolJobScheduler(), pruningStrategy);
            long totalCommittedEntries = log.appendIndex();
            int i = 0;
            while ((long)i <= totalCommittedEntries) {
                ReplicatedContent content = RaftLogHelper.readLogEntry((ReadableRaftLog)log, i).content();
                if (content instanceof ReplicatedTransaction) {
                    ReplicatedTransaction tx = (ReplicatedTransaction)content;
                    ReplicatedTransactionFactory.extractTransactionRepresentation((ReplicatedTransaction)tx, (byte[])new byte[0]).accept(element -> {
                        System.out.println(element);
                        return false;
                    });
                }
                ++i;
            }
        }
    }
}

