/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;

public class RaftLogHelper {
    private RaftLogHelper() {
    }

    public static RaftLogEntry readLogEntry(ReadableRaftLog raftLog, long index) throws IOException {
        try (RaftLogCursor cursor = raftLog.getEntryCursor(index);){
            if (cursor.next()) {
                RaftLogEntry raftLogEntry = (RaftLogEntry)cursor.get();
                return raftLogEntry;
            }
        }
        throw new IOException("Asked for raft log entry at index " + index + " but it was not found");
    }

    public static Matcher<? super RaftLog> hasNoContent(final long index) {
        return new TypeSafeMatcher<RaftLog>(){

            protected boolean matchesSafely(RaftLog log) {
                try {
                    RaftLogHelper.readLogEntry((ReadableRaftLog)log, index);
                }
                catch (IOException e) {
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Log should not contain entry at index ").appendValue((Object)index);
            }
        };
    }
}

