/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.explorer.action;

import java.util.Collection;
import java.util.LinkedList;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.explorer.ClusterState;
import org.neo4j.causalclustering.core.consensus.explorer.action.Action;
import org.neo4j.causalclustering.identity.MemberId;

public class OutOfOrderDelivery
implements Action {
    private final MemberId member;

    public OutOfOrderDelivery(MemberId member) {
        this.member = member;
    }

    @Override
    public ClusterState advance(ClusterState previous) {
        ClusterState newClusterState = new ClusterState(previous);
        LinkedList<RaftMessages.RaftMessage> inboundQueue = new LinkedList<RaftMessages.RaftMessage>((Collection)previous.queues.get(this.member));
        if (inboundQueue.size() < 2) {
            return previous;
        }
        RaftMessages.RaftMessage message = (RaftMessages.RaftMessage)inboundQueue.poll();
        inboundQueue.add(1, message);
        newClusterState.queues.put(this.member, inboundQueue);
        return newClusterState;
    }
}

