/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.MajorityIncludingSelfQuorum;

public class QuorumStrategyTest {
    @Test
    public void shouldDecideIfWeHaveAMajorityCorrectly() {
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)1, (int)0));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)2, (int)0));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)2, (int)1));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)3, (int)0));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)3, (int)1));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)3, (int)2));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)4, (int)0));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)4, (int)1));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)4, (int)2));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)4, (int)3));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)5, (int)0));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)5, (int)1));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)5, (int)2));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)5, (int)3));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)0, (int)5, (int)4));
    }

    @Test
    public void shouldDecideIfWeHaveAMajorityCorrectlyUsingMinQuorum() {
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)1, (int)0));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)2, (int)0));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)2, (int)1));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)3, (int)0));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)3, (int)1));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)3, (int)2));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)4, (int)0));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)4, (int)1));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)4, (int)2));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)4, (int)3));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)5, (int)0));
        Assert.assertFalse((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)5, (int)1));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)5, (int)2));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)5, (int)3));
        Assert.assertTrue((boolean)MajorityIncludingSelfQuorum.isQuorum((int)2, (int)5, (int)4));
    }
}

