/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.Message;

public class DirectNetworking {
    private final Map<MemberId, Inbound.MessageHandler> handlers = new HashMap<MemberId, Inbound.MessageHandler>();
    private final Map<MemberId, Queue<Message>> messageQueues = new HashMap<MemberId, Queue<Message>>();
    private final Set<MemberId> disconnectedMembers = Collections.newSetFromMap(new ConcurrentHashMap());

    public void processMessages() {
        while (this.messagesToBeProcessed()) {
            for (Map.Entry<MemberId, Queue<Message>> entry : this.messageQueues.entrySet()) {
                MemberId id = entry.getKey();
                Queue<Message> queue = entry.getValue();
                if (queue.isEmpty()) continue;
                Message message = queue.remove();
                this.handlers.get(id).handle(message);
            }
        }
    }

    private boolean messagesToBeProcessed() {
        for (Queue<Message> queue : this.messageQueues.values()) {
            if (queue.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void disconnect(MemberId id) {
        this.disconnectedMembers.add(id);
    }

    public void reconnect(MemberId id) {
        this.disconnectedMembers.remove(id);
    }

    public class Inbound<M extends Message>
    implements org.neo4j.causalclustering.messaging.Inbound<M> {
        private final MemberId id;

        public Inbound(MemberId id) {
            this.id = id;
        }

        public void registerHandler(Inbound.MessageHandler handler) {
            DirectNetworking.this.handlers.put(this.id, handler);
            DirectNetworking.this.messageQueues.put(this.id, new LinkedList());
        }
    }

    public class Outbound
    implements org.neo4j.causalclustering.messaging.Outbound<MemberId, RaftMessages.RaftMessage> {
        private final MemberId me;

        public Outbound(MemberId me) {
            this.me = me;
        }

        public synchronized void send(MemberId to, RaftMessages.RaftMessage message, boolean block) {
            if (this.canDeliver(to)) {
                ((Queue)DirectNetworking.this.messageQueues.get(to)).add(message);
            }
        }

        private boolean canDeliver(MemberId to) {
            return DirectNetworking.this.messageQueues.containsKey(to) && !DirectNetworking.this.disconnectedMembers.contains(to) && !DirectNetworking.this.disconnectedMembers.contains(this.me);
        }
    }
}

