/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.OptionalInt;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.HostnamePortAsListenAddress;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;

@RunWith(value=Parameterized.class)
public class HostnamePortAsListenAddressTest {
    private final String hostname;
    private final int port;
    private final OptionalInt portRange;
    private final boolean isIpV6;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"[Should ignore port range correctly]", "localhost", 4343, OptionalInt.of(4646), false}, {"[Should handle hostname with dashes]", "foo-bar", 1234, OptionalInt.empty(), false}, {"[Should handle standard hostname with port]", "localhost", 251, OptionalInt.empty(), false}, {"[Should handle hostname with tld ext]", "neo4j.org", 1212, OptionalInt.empty(), false}, {"[Should ignore port range for hostname with tld ext]", "neo4j.org", 1212, OptionalInt.of(2121), false}, {"[Should handle hostname with sub-domain]", "test.neo4j.org", 1212, OptionalInt.empty(), false}, {"[Should handle ipv4 hostname]", "8.8.8.8", 1212, OptionalInt.of(2121), false}, {"[Should handle ipv6 hostname]", "[2001:cdba:0000:0000:0000:0000:3257:9652]", 1212, OptionalInt.empty(), true}, {"[Should handle ipv6 hostname with port range]", "[2001:cdba::3257:9652]", 1212, OptionalInt.of(2121), true});
    }

    public HostnamePortAsListenAddressTest(String ignoredName, String hostname, int port, OptionalInt portRange, boolean isIpV6) {
        this.hostname = hostname;
        this.port = port;
        this.portRange = portRange;
        this.isIpV6 = isIpV6;
    }

    private String combinedHostname() {
        String portRangeStr = this.portRange.isPresent() ? "-" + this.portRange.getAsInt() : "";
        return this.hostname + ":" + this.port + portRangeStr;
    }

    private String getSanitizedHostname() {
        if (this.isIpV6) {
            if (!this.hostname.startsWith("[") || !this.hostname.endsWith("]")) {
                throw new IllegalArgumentException("Test indicates an IpV6 hostname and port but isn't surrounded by []");
            }
            return this.hostname.substring(1, this.hostname.length() - 1);
        }
        return this.hostname;
    }

    @Test
    public void shouldParseHostnamePortCorrectly() {
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, this.combinedHostname()).build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)new ListenSocketAddress(this.getSanitizedHostname(), this.port), (Object)listenSocketAddress);
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldThrowInvalidSettingsExceptionOnEmptyConfig() {
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, "").build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)OnlineBackupSettings.online_backup_server.getDefaultValue(), (Object)listenSocketAddress.toString());
    }

    @Test(expected=InvalidSettingException.class)
    public void shouldThrowInvalidSettingsExceptionOnBadFormat() {
        Config config = Config.builder().withSetting(OnlineBackupSettings.online_backup_server, "localhost").build();
        ListenSocketAddress listenSocketAddress = HostnamePortAsListenAddress.resolve((Config)config, (Setting)OnlineBackupSettings.online_backup_server);
        Assert.assertEquals((Object)OnlineBackupSettings.online_backup_server.getDefaultValue(), (Object)listenSocketAddress.toString());
    }
}

