/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.BoundedPriorityQueue;

public class BoundedPriorityQueueTest {
    private final BoundedPriorityQueue.Config BASE_CONFIG = new BoundedPriorityQueue.Config(0, 5, 100L);
    private final Comparator<Integer> NO_PRIORITY = (a, b) -> 0;
    private final ThreadLocalRandom tlr = ThreadLocalRandom.current();

    @Test
    public void shouldReportTotalCountAndSize() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((long)0L, (long)queue.bytes());
        Assert.assertEquals((long)0L, (long)queue.count());
        queue.offer((Object)10);
        Assert.assertEquals((long)1L, (long)queue.count());
        Assert.assertEquals((long)10L, (long)queue.bytes());
        queue.offer((Object)20);
        Assert.assertEquals((long)2L, (long)queue.count());
        Assert.assertEquals((long)30L, (long)queue.bytes());
        queue.poll();
        Assert.assertEquals((long)1L, (long)queue.count());
        Assert.assertEquals((long)20L, (long)queue.bytes());
        queue.poll();
        Assert.assertEquals((long)0L, (long)queue.count());
        Assert.assertEquals((long)0L, (long)queue.bytes());
    }

    @Test
    public void shouldNotAllowMoreThanMaxBytes() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.E_SIZE_EXCEEDED, (Object)queue.offer((Object)101));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)99));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.E_SIZE_EXCEEDED, (Object)queue.offer((Object)1));
    }

    @Test
    public void shouldAllowMinCountDespiteSizeLimit() {
        BoundedPriorityQueue.Config config = new BoundedPriorityQueue.Config(2, 5, 100L);
        BoundedPriorityQueue queue = new BoundedPriorityQueue(config, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)101));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)101));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.E_SIZE_EXCEEDED, (Object)queue.offer((Object)1));
    }

    @Test
    public void shouldAllowZeroSizedItemsDespiteSizeLimit() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)100));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.E_SIZE_EXCEEDED, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
    }

    @Test
    public void shouldNotAllowMoreThanMaxCount() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.E_COUNT_EXCEEDED, (Object)queue.offer((Object)1));
    }

    @Test
    public void shouldNotAllowMoreThanMaxCountDespiteZeroSize() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)0));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.E_COUNT_EXCEEDED, (Object)queue.offer((Object)0));
    }

    @Test
    public void shouldBeAbleToPeekEntries() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)2));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)3));
        Assert.assertEquals(Optional.of(1), queue.peek().map(BoundedPriorityQueue.Removable::get));
        Assert.assertEquals(Optional.of(1), queue.peek().map(BoundedPriorityQueue.Removable::get));
        Assert.assertEquals(Optional.of(1), queue.peek().map(BoundedPriorityQueue.Removable::get));
        Assert.assertEquals((long)3L, (long)queue.count());
        Assert.assertEquals((long)6L, (long)queue.bytes());
    }

    @Test
    public void shouldBeAbleToRemovePeekedEntries() {
        BoundedPriorityQueue queue = new BoundedPriorityQueue(this.BASE_CONFIG, Integer::longValue, this.NO_PRIORITY);
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)1));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)2));
        Assert.assertEquals((Object)BoundedPriorityQueue.Result.OK, (Object)queue.offer((Object)3));
        Assert.assertEquals((long)3L, (long)queue.count());
        Assert.assertEquals((long)6L, (long)queue.bytes());
        Assert.assertTrue((boolean)queue.peek().isPresent());
        Assert.assertTrue((boolean)((BoundedPriorityQueue.Removable)queue.peek().get()).remove());
        Assert.assertEquals((long)2L, (long)queue.count());
        Assert.assertEquals((long)5L, (long)queue.bytes());
        Assert.assertTrue((boolean)queue.peek().isPresent());
        Assert.assertTrue((boolean)((BoundedPriorityQueue.Removable)queue.peek().get()).remove());
        Assert.assertEquals((long)1L, (long)queue.count());
        Assert.assertEquals((long)3L, (long)queue.bytes());
        Assert.assertTrue((boolean)queue.peek().isPresent());
        Assert.assertTrue((boolean)((BoundedPriorityQueue.Removable)queue.peek().get()).remove());
        Assert.assertEquals((long)0L, (long)queue.count());
        Assert.assertEquals((long)0L, (long)queue.bytes());
        Assert.assertFalse((boolean)queue.peek().isPresent());
        try {
            ((BoundedPriorityQueue.Removable)queue.peek().get()).remove();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void shouldRespectPriority() {
        int i2;
        int count = 100;
        BoundedPriorityQueue.Config config = new BoundedPriorityQueue.Config(0, count, 0L);
        BoundedPriorityQueue queue = new BoundedPriorityQueue(config, i -> 0L, Integer::compare);
        ArrayList<Integer> list = new ArrayList<Integer>(count);
        for (i2 = 0; i2 < count; ++i2) {
            list.add(i2);
        }
        Collections.shuffle(list, this.tlr);
        list.forEach(arg_0 -> ((BoundedPriorityQueue)queue).offer(arg_0));
        for (i2 = 0; i2 < count; ++i2) {
            Assert.assertEquals(Optional.of(i2), (Object)queue.poll());
        }
    }

    @Test
    public void shouldHaveStablePriority() {
        int count = 100;
        int priorities = 3;
        BoundedPriorityQueue.Config config = new BoundedPriorityQueue.Config(0, count, 0L);
        BoundedPriorityQueue queue = new BoundedPriorityQueue(config, i -> 0L, Comparator.comparingInt(p -> p.priority));
        ArrayList<Element> insertionOrder = new ArrayList<Element>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            insertionOrder.add(new Element(this.tlr.nextInt(priorities)));
        }
        Collections.shuffle(insertionOrder, this.tlr);
        insertionOrder.forEach(arg_0 -> ((BoundedPriorityQueue)queue).offer(arg_0));
        for (int p2 = 0; p2 < priorities; ++p2) {
            ArrayList<Element> filteredInsertionOrder = new ArrayList<Element>();
            for (Element element : insertionOrder) {
                if (element.priority != p2) continue;
                filteredInsertionOrder.add(element);
            }
            for (Element element : filteredInsertionOrder) {
                Assert.assertEquals(Optional.of(element), (Object)queue.poll());
            }
        }
    }

    class Element {
        int priority;

        Element(int priority) {
            this.priority = priority;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return Objects.hash(this.priority);
        }
    }
}

