/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseDecoder;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseEncoder;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

public class TxPullResponseEncodeDecodeTest {
    @Test
    public void shouldEncodeAndDecodePullResponseMessage() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new TxPullResponseEncoder(), new TxPullResponseDecoder()});
        TxPullResponse sent = new TxPullResponse(new StoreId(1L, 2L, 3L, 4L), this.newCommittedTransactionRepresentation());
        channel.writeOutbound(new Object[]{sent});
        Object message = channel.readOutbound();
        channel.writeInbound(new Object[]{message});
        TxPullResponse received = (TxPullResponse)channel.readInbound();
        Assert.assertNotSame((Object)sent, (Object)received);
        Assert.assertEquals((Object)sent, (Object)received);
    }

    private CommittedTransactionRepresentation newCommittedTransactionRepresentation() {
        long arbitraryRecordId = 27L;
        Command.NodeCommand command = new Command.NodeCommand(new NodeRecord(27L), new NodeRecord(27L));
        PhysicalTransactionRepresentation physicalTransactionRepresentation = new PhysicalTransactionRepresentation(Collections.singletonList(new LogEntryCommand((StorageCommand)command).getCommand()));
        physicalTransactionRepresentation.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        LogEntryStart startEntry = new LogEntryStart(0, 0, 0L, 0L, new byte[0], LogPosition.UNSPECIFIED);
        LogEntryCommit commitEntry = new LogEntryCommit(42L, 0L);
        return new CommittedTransactionRepresentation(startEntry, (TransactionRepresentation)physicalTransactionRepresentation, commitEntry);
    }
}

