/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupProtocolServerInstaller;
import org.neo4j.causalclustering.catchup.CatchupServerHandler;
import org.neo4j.causalclustering.catchup.CheckPointerService;
import org.neo4j.causalclustering.catchup.RegularCatchupServerHandler;
import org.neo4j.causalclustering.handlers.VoidPipelineWrapperFactory;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.net.ChildInitializer;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServerInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ports.allocation.PortAuthority;
import org.neo4j.scheduler.Group;

class TestCatchupServer
extends Server {
    private static final LogProvider LOG_PROVIDER = NullLogProvider.getInstance();

    TestCatchupServer(FileSystemAbstraction fileSystem, GraphDatabaseAPI graphDb) {
        super(TestCatchupServer.childInitializer(fileSystem, graphDb), LOG_PROVIDER, LOG_PROVIDER, new ListenSocketAddress("localhost", PortAuthority.allocatePort()), "fake-catchup-server");
    }

    private static ChildInitializer childInitializer(FileSystemAbstraction fileSystem, GraphDatabaseAPI graphDb) {
        ApplicationSupportedProtocols catchupProtocols = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.CATCHUP, Collections.emptyList());
        ModifierSupportedProtocols modifierProtocols = new ModifierSupportedProtocols((Protocol.Category)Protocol.ModifierProtocolCategory.COMPRESSION, Collections.emptyList());
        ApplicationProtocolRepository catchupRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])Protocol.ApplicationProtocols.values(), catchupProtocols);
        ModifierProtocolRepository modifierRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])Protocol.ModifierProtocols.values(), Collections.singletonList(modifierProtocols));
        Supplier<CheckPointer> checkPointer = () -> (CheckPointer)graphDb.getDependencyResolver().resolveDependency(CheckPointer.class);
        BooleanSupplier availability = () -> ((DatabaseAvailabilityGuard)graphDb.getDependencyResolver().resolveDependency(DatabaseAvailabilityGuard.class)).isAvailable();
        Supplier<NeoStoreDataSource> dataSource = () -> (NeoStoreDataSource)graphDb.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        org.neo4j.storageengine.api.StoreId kernelStoreId = dataSource.get().getStoreId();
        StoreId storeId = new StoreId(kernelStoreId.getCreationTime(), kernelStoreId.getRandomId(), kernelStoreId.getUpgradeTime(), kernelStoreId.getUpgradeId());
        CheckPointerService checkPointerService = new CheckPointerService(checkPointer, JobSchedulerFactory.createInitialisedScheduler(), Group.CHECKPOINT);
        RegularCatchupServerHandler catchupServerHandler = new RegularCatchupServerHandler(new Monitors(), (LogProvider)logProvider, () -> storeId, dataSource, availability, fileSystem, null, checkPointerService);
        NettyPipelineBuilderFactory pipelineBuilder = new NettyPipelineBuilderFactory(VoidPipelineWrapperFactory.VOID_WRAPPER);
        CatchupProtocolServerInstaller.Factory catchupProtocolServerInstaller = new CatchupProtocolServerInstaller.Factory(pipelineBuilder, (LogProvider)logProvider, (CatchupServerHandler)catchupServerHandler);
        ProtocolInstallerRepository protocolInstallerRepository = new ProtocolInstallerRepository(Collections.singletonList(catchupProtocolServerInstaller), (Collection)ModifierProtocolInstaller.allServerInstallers);
        return new HandshakeServerInitializer(catchupRepository, modifierRepository, protocolInstallerRepository, pipelineBuilder, (LogProvider)logProvider);
    }
}

